/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestCoder;
import com.novell.nds.dirxml.vrtest.VRTestEventType;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestReturnType;

class VRTestDecoder
extends VRTestCoder
implements Constants {
    protected static final int AVG_STRING_LEN_CHARS = 15;
    protected String encoding;
    protected int index;
    protected int length;

    private VRTestDecoder() {
    }

    VRTestDecoder(String string) {
        this.encoding = string;
        this.length = string.length();
        this.index = 0;
    }

    int getInt() throws VRTestException {
        String string = this.getString();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRTestException("Parse Error!  Expecting integer.");
        }
    }

    long getLong() throws VRTestException {
        String string = this.getString();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRTestException("Parse Error!  Expecting long.");
        }
    }

    String getReturnType() throws VRTestException {
        String string = this.getString();
        string = VRTestReturnType.lookupType(string);
        return string;
    }

    private boolean isInvalidIndex(int n) {
        return n < 0 || n > this.length;
    }

    private boolean isEscaped(int n) {
        if (n >= 2) {
            return this.encoding.charAt(n - 1) == '\\' && this.encoding.charAt(n - 2) != '\\';
        }
        if (n == 1) {
            return this.encoding.charAt(n - 1) == '\\';
        }
        return false;
    }

    private int findCharIndex(char c) throws VRTestException {
        int n = this.index;
        while (n < this.length) {
            if ((n = this.encoding.indexOf(c, n)) == -1) {
                throw new VRTestException(Errors.ExpectingChar(c));
            }
            if (!this.isEscaped(n)) {
                return n;
            }
            ++n;
        }
        throw new VRTestException(Errors.ExpectingChar(c));
    }

    String getString() throws VRTestException {
        StringBuffer stringBuffer = new StringBuffer(15);
        int n = this.findCharIndex('{') + 1;
        boolean bl = false;
        char c = 'c';
        while (n < this.length) {
            if ((c = (char)this.encoding.charAt(n++)) == '}') {
                if (bl) continue;
                break;
            }
            if (c == '\\') {
                if (!bl) {
                    bl = true;
                    stringBuffer.append(c);
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
            stringBuffer.append(c);
        }
        if (c != '}') {
            throw new VRTestException(Errors.ExpectingChar('}'));
        }
        this.index = n;
        return stringBuffer.toString();
    }

    private boolean areRemainingChars() {
        return this.index < this.length;
    }

    private boolean outOfChars() {
        return this.index >= this.length;
    }

    private char getNextChar() {
        return this.encoding.charAt(this.index++);
    }

    private char getCurrentChar() {
        return this.encoding.charAt(this.index);
    }

    private void stripWhiteSpaces() {
        while (this.areRemainingChars() && Character.isWhitespace(this.getCurrentChar())) {
            this.getNextChar();
        }
    }

    /*
     * Unable to fully structure code
     */
    VRTestAttributeList getAttributes() throws VRTestException {
        var1_1 = new VRTestAttributeList();
        this.index = this.findCharIndex('{') + 1;
        var2_2 = 97;
        if (true) ** GOTO lbl9
        do {
            var3_3 = this.getAttribute();
            var1_1.addAttribute(var3_3);
            this.stripWhiteSpaces();
lbl9:
            // 2 sources

            if (!this.areRemainingChars()) break;
            v0 = this.getCurrentChar();
            var2_2 = v0;
        } while (v0 != '}');
        if (var2_2 != 125) {
            throw new VRTestException(Errors.ExpectingChar('}'));
        }
        this.getNextChar();
        return var1_1;
    }

    private VRTestAttribute getAttribute() throws VRTestException {
        this.index = this.findCharIndex('{') + 1;
        String string = this.getString();
        String string2 = this.getString();
        VRTestAction vRTestAction = this.getAction();
        this.index = this.findCharIndex('}') + 1;
        return new VRTestAttribute(string, string2, vRTestAction);
    }

    private VRTestAction getAction() throws VRTestException {
        return VRTestAction.lookupAction(this.getString());
    }

    long getHandle() throws VRTestException {
        return this.getLong();
    }

    VRTestEventType getEventType() throws VRTestException {
        return VRTestEventType.lookupType(this.getString());
    }

    int getID() throws VRTestException {
        return this.getInt();
    }
}

