/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestCoder;
import java.util.ListIterator;

class VRTestEncoder
extends VRTestCoder
implements Constants {
    protected static final int DEFAULT_BUFFER_SIZE_CHARS = 48;
    private StringBuffer buffer = new StringBuffer(48);

    static boolean isReservedChar(char c) {
        return c == '{' || c == '}' || c == '\\';
    }

    VRTestEncoder() {
    }

    void encodeCommand(String string) {
        this.encodeString(string.toString());
    }

    void encodeLong(long l) {
        this.encodeString(String.valueOf(l));
    }

    void encodeString(String string) {
        this.buffer.append('{');
        if (string != null) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (VRTestEncoder.isReservedChar(c)) {
                    this.buffer.append('\\');
                }
                this.buffer.append(c);
                ++n2;
            }
        }
        this.buffer.append('}');
    }

    void encodeHandle(long l) {
        this.encodeLong(l);
    }

    void encodeAttributes(VRTestAttributeList vRTestAttributeList) {
        this.buffer.append('{');
        if (vRTestAttributeList != null) {
            ListIterator listIterator = vRTestAttributeList.attributes().listIterator();
            while (listIterator.hasNext()) {
                VRTestAttribute vRTestAttribute = (VRTestAttribute)listIterator.next();
                String string = vRTestAttribute.getName();
                String string2 = vRTestAttribute.getValue();
                VRTestAction vRTestAction = vRTestAttribute.getAction();
                this.buffer.append('{');
                this.encodeString(string);
                this.encodeString(string2);
                this.encodeString(vRTestAction.toString());
                this.buffer.append('}');
            }
        }
        this.buffer.append('}');
    }

    String getEncoding() {
        return this.buffer.toString();
    }
}

