/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestMetaData;
import com.novell.nds.dirxml.vrtest.VRTestSchemaParser;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class VRTestSchema
implements Constants,
VRTestConstants,
VRTestMetaData {
    private String name;
    private boolean hierarchical;
    private boolean uniqueIDs;
    private boolean subtreeDelete;
    private boolean caseSensitive;
    private List classSchemas;

    private VRTestSchema() {
    }

    public VRTestSchema(String string) throws VRTestException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.NullParam("streamedSchema"));
        }
        this.hierarchical = false;
        this.uniqueIDs = true;
        this.subtreeDelete = false;
        this.caseSensitive = true;
        this.classSchemas = new Vector();
        VRTestTokenizer vRTestTokenizer = new VRTestTokenizer(string);
        VRTestSchemaParser vRTestSchemaParser = new VRTestSchemaParser(this, vRTestTokenizer);
        vRTestSchemaParser.parse();
        this.addObjectPaths();
        this.addUniqueIDs();
    }

    void setHierarchical(boolean bl) {
        this.hierarchical = bl;
    }

    void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    void setSubtreeDelete(boolean bl) {
        this.subtreeDelete = bl;
    }

    public boolean canSubtreeDelete() {
        return this.subtreeDelete;
    }

    void setUniqueIDs(boolean bl) {
        this.uniqueIDs = bl;
    }

    public boolean hasUniqueIDs() {
        return this.uniqueIDs;
    }

    void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void addClassSchema(VRTestClassSchema vRTestClassSchema) {
        this.classSchemas.add(vRTestClassSchema);
    }

    private void addObjectPaths() throws VRTestException {
        if (this.hierarchical) {
            VRTestAttributeSchema vRTestAttributeSchema = new VRTestAttributeSchema();
            vRTestAttributeSchema.setName("Object Path");
            vRTestAttributeSchema.setMaxLength(2048);
            vRTestAttributeSchema.setRequired(true);
            vRTestAttributeSchema.setMultiValued(false);
            vRTestAttributeSchema.setIndexed(true);
            vRTestAttributeSchema.setUnique(false);
            vRTestAttributeSchema.setCaseSensitive(this.caseSensitive);
            ListIterator listIterator = this.classSchemas.listIterator();
            while (listIterator.hasNext()) {
                VRTestClassSchema vRTestClassSchema = (VRTestClassSchema)listIterator.next();
                if (vRTestClassSchema.getAttributeSchema("Object Path") != null) continue;
                vRTestClassSchema.addAttributeSchema(vRTestAttributeSchema);
            }
        }
    }

    private void addUniqueIDs() throws VRTestException {
        if (this.uniqueIDs) {
            VRTestAttributeSchema vRTestAttributeSchema = new VRTestAttributeSchema();
            vRTestAttributeSchema.setName("Unique Id");
            vRTestAttributeSchema.setMaxLength(10);
            vRTestAttributeSchema.setRequired(true);
            vRTestAttributeSchema.setMultiValued(false);
            vRTestAttributeSchema.setIndexed(true);
            vRTestAttributeSchema.setUnique(true);
            vRTestAttributeSchema.setCaseSensitive(false);
            vRTestAttributeSchema.setReadOnly(true);
            ListIterator listIterator = this.classSchemas.listIterator();
            while (listIterator.hasNext()) {
                VRTestClassSchema vRTestClassSchema = (VRTestClassSchema)listIterator.next();
                if (vRTestClassSchema.getAttributeSchema("Unique Id") != null) continue;
                vRTestClassSchema.addAttributeSchema(vRTestAttributeSchema);
            }
        }
    }

    public VRTestClassSchema getClassSchema(String string) {
        if (string == null) {
            return null;
        }
        ListIterator listIterator = this.classSchemas.listIterator();
        while (listIterator.hasNext()) {
            VRTestClassSchema vRTestClassSchema = (VRTestClassSchema)listIterator.next();
            if (!vRTestClassSchema.equals(string)) continue;
            return vRTestClassSchema;
        }
        return null;
    }

    public List getClassSchemas() {
        return this.classSchemas;
    }
}

