/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchemaParser;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;

class VRTestSchemaParser
implements Constants {
    private VRTestSchema schema;
    private VRTestTokenizer tokenizer;

    VRTestSchemaParser(VRTestSchema vRTestSchema, VRTestTokenizer vRTestTokenizer) throws VRTestException {
        this.schema = vRTestSchema;
        this.tokenizer = vRTestTokenizer;
    }

    void parse() throws VRTestException {
        VRTestToken vRTestToken = this.tokenizer.getNextToken();
        while (vRTestToken != Constants.NO_MORE_TOKEN) {
            if (!(vRTestToken instanceof VRTestKeywordToken)) {
                throw new VRTestException("Parse Error!  Expecting keyword.");
            }
            this.handleKeyword(((VRTestKeywordToken)vRTestToken).getKeyword());
            vRTestToken = this.tokenizer.getNextToken();
        }
    }

    private void handleKeyword(VRTestKeyword vRTestKeyword) throws VRTestException {
        if (vRTestKeyword == VRTestKeyword.SCHEMA) {
            this.handleName();
        } else if (vRTestKeyword == VRTestKeyword.CLASS) {
            this.handleClass();
        } else {
            this.handleBoolean(vRTestKeyword);
        }
    }

    private void handleName() throws VRTestException {
        VRTestToken vRTestToken = this.tokenizer.getNextToken();
        if (!(vRTestToken instanceof VRTestStringToken)) {
            throw new VRTestException("Parse Error!  Expecting string.");
        }
        this.schema.setName(((VRTestStringToken)vRTestToken).getString());
    }

    private void handleClass() throws VRTestException {
        VRTestClassSchema vRTestClassSchema = new VRTestClassSchema();
        vRTestClassSchema.setCaseSensitive(this.schema.isCaseSensitive());
        VRTestClassSchemaParser vRTestClassSchemaParser = new VRTestClassSchemaParser(vRTestClassSchema, this.tokenizer);
        vRTestClassSchemaParser.parse();
        this.schema.addClassSchema(vRTestClassSchema);
    }

    private void handleBoolean(VRTestKeyword vRTestKeyword) throws VRTestException {
        boolean bl = this.tokenizer.getBooleanValue();
        if (vRTestKeyword == VRTestKeyword.CASESENSITIVE) {
            this.schema.setCaseSensitive(bl);
        } else if (vRTestKeyword == VRTestKeyword.HIERARCHICAL) {
            this.schema.setHierarchical(bl);
        } else if (vRTestKeyword == VRTestKeyword.SUBTREEDELETE) {
            this.schema.setSubtreeDelete(bl);
        } else if (vRTestKeyword == VRTestKeyword.UNIQUEIDS) {
            this.schema.setUniqueIDs(bl);
        }
    }
}

