/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestIntegerToken;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestRealToken;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;

class VRTestTokenizer
implements Constants {
    private static final int AVG_NUM_SIZE_DIGITS = 10;
    private static final int AVG_STRING_SIZE_CHARS = 15;
    private int index;
    private int length;
    private String stream;
    private VRTestToken peekToken;

    VRTestTokenizer(String string) {
        this.stream = string;
        this.length = this.stream.length();
        this.index = 0;
        this.peekToken = null;
    }

    VRTestToken peekNextToken() throws VRTestException {
        if (this.peekToken == null) {
            this.peekToken = this.getNextToken();
            return this.peekToken;
        }
        return this.peekToken;
    }

    void consumeToken() {
        this.peekToken = null;
    }

    VRTestToken getNextToken() throws VRTestException {
        char c;
        if (this.peekToken != null) {
            VRTestToken vRTestToken = this.peekToken;
            this.consumeToken();
            return vRTestToken;
        }
        while (true) {
            if (this.outOfChars()) {
                return Constants.NO_MORE_TOKEN;
            }
            c = this.getNextChar();
            if (Character.isWhitespace(c)) continue;
            if (this.isNumberStart(c)) {
                return this.parseIntegerORReal(c);
            }
            if (VRTestTokenizer.isStringStart(c)) {
                return this.parseString();
            }
            if (this.isKeywordORIdentStart(c)) break;
        }
        return this.parseKeywordORIdent(c);
    }

    boolean getBooleanValue() throws VRTestException {
        VRTestToken vRTestToken = this.getNextToken();
        if (!(vRTestToken instanceof VRTestKeywordToken)) {
            throw new VRTestException("Parse Error!  Expecting keyword.");
        }
        VRTestKeyword vRTestKeyword = ((VRTestKeywordToken)vRTestToken).getKeyword();
        if (vRTestKeyword == VRTestKeyword.TRUE) {
            return true;
        }
        if (vRTestKeyword == VRTestKeyword.FALSE) {
            return false;
        }
        throw new VRTestException("Parse Error!  Expecting boolean keyword.");
    }

    private static boolean isStringStart(char c) {
        return c == '\"';
    }

    private boolean outOfChars() {
        return this.index == this.length;
    }

    private char getNextChar() {
        return this.stream.charAt(this.index++);
    }

    private void putBackChar() {
        --this.index;
    }

    private boolean isNumberStart(char c) {
        return Character.isDigit(c) || c == '.' || c == '-' || c == '+';
    }

    private boolean isKeywordORIdentStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private VRTestToken parseIntegerORReal(char c) throws VRTestException {
        boolean bl = c == '.';
        boolean bl2 = c == '0';
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(c);
        while (!this.outOfChars()) {
            char c2 = this.getNextChar();
            if (c2 == '.') {
                if (bl || bl3) {
                    throw new VRTestException("Parse Error!  Illegal number.");
                }
                bl = true;
            } else if (this.isHexPrefix(bl2, c2)) {
                bl3 = true;
            } else if (this.isNonNumericChar(bl3, c2)) {
                this.putBackChar();
                break;
            }
            stringBuffer.append(c2);
            bl2 = false;
        }
        String string = stringBuffer.toString();
        if (bl) {
            return new VRTestRealToken(string);
        }
        return new VRTestIntegerToken(string);
    }

    private int getRadix(boolean bl) {
        if (bl) {
            return 16;
        }
        return 10;
    }

    private boolean isHexPrefix(boolean bl, char c) {
        return bl && (c == 'x' || c == 'X');
    }

    private boolean isEscapeChar(boolean bl, char c) {
        return c == '\\' && !bl;
    }

    private boolean isIdentORKeywordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private boolean isEndQuote(boolean bl, char c) {
        return c == '\"' && !bl;
    }

    private boolean isNonNumericChar(boolean bl, char c) {
        return (!bl || !Character.isLetter(c)) && !Character.isDigit(c);
    }

    private VRTestToken parseString() {
        StringBuffer stringBuffer = new StringBuffer(15);
        boolean bl = false;
        while (!this.outOfChars()) {
            char c = this.getNextChar();
            if (this.isEscapeChar(bl, c)) {
                bl = true;
                continue;
            }
            if (this.isEndQuote(bl, c)) break;
            stringBuffer.append(c);
            bl = false;
        }
        return new VRTestStringToken(stringBuffer.toString());
    }

    private VRTestToken parseKeywordORIdent(char c) throws VRTestException {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(c);
        boolean bl = false;
        while (!bl && !this.outOfChars()) {
            char c2 = this.getNextChar();
            if (this.isIdentORKeywordChar(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            this.putBackChar();
            bl = true;
        }
        VRTestKeyword vRTestKeyword = VRTestKeyword.getKeyword(stringBuffer.toString());
        if (vRTestKeyword == null) {
            throw new VRTestException("Parse Error!  Identifiers unsupported.");
        }
        return new VRTestKeywordToken(vRTestKeyword);
    }
}

