/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

class EncoderWrapper
extends CharEncoder {
    protected CharsetEncoder encoder;

    EncoderWrapper(CharsetEncoder charsetEncoder) {
        this.encoder = charsetEncoder;
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private void handleResult(CharBuffer charBuffer, ByteBuffer byteBuffer, CoderResult coderResult) throws CharEncodingException, EncodingBufferFullException {
        if (coderResult.isOverflow()) {
            throw new EncodingBufferFullException(byteBuffer.position(), charBuffer.position());
        }
        if (coderResult.isUnmappable()) {
            int n = charBuffer.position();
            int n2 = charBuffer.get(n);
            if (55296 <= n2 && n2 < 56320 && charBuffer.limit() - n >= 1) {
                char c = charBuffer.get(n + 1);
                n2 = (n2 - 55296 << 10) + (c - 56320) + 65536;
            }
            throw new CharEncodingException(n2, n, byteBuffer.position());
        }
    }

    public int encodeChars(char[] cArray, int n, int n2, byte[] byArray, int n3) throws CharEncodingException, EncodingBufferFullException {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n3, byArray.length - n3);
        this.encoder.reset();
        CoderResult coderResult = this.encoder.encode(charBuffer, byteBuffer, true);
        this.handleResult(charBuffer, byteBuffer, coderResult);
        coderResult = this.encoder.flush(byteBuffer);
        this.handleResult(charBuffer, byteBuffer, coderResult);
        return byteBuffer.position() - n3;
    }

    public void reset() {
        this.encoder.reset();
    }

    public int encodeChar(int n, byte[] byArray, int n2) throws CharEncodingException, EncodingBufferFullException {
        char[] cArray = new char[2];
        if (n < 65535) {
            cArray[0] = (char)n;
            return this.encodeChars(cArray, 0, 1, byArray, n2);
        }
        int n3 = (n - 65536 >> 10) + 55296;
        int n4 = (n - 65536 & 0x3FF) + 56320;
        cArray[0] = (char)n3;
        cArray[1] = (char)n4;
        return this.encodeChars(cArray, 0, 2, byArray, n2);
    }

    public String getEncoding() {
        return this.encoder.charset().name();
    }
}

