/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.ChildNodeList;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DOMImplementationImpl;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.DocumentOrderComparator;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import java.io.IOException;
import java.io.StringWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class NodeImpl
implements Node,
Cloneable,
Comparable {
    protected String nodeName = null;
    protected String nodeValue = null;
    protected int changeCount = 0;
    protected DocumentImpl document = null;
    protected NodeImpl parentNode = null;
    protected NodeImpl firstChild = null;
    protected NodeImpl lastChild = null;
    protected NodeImpl nextSibling = null;
    protected NodeImpl previousSibling = null;
    protected String namespaceURI = null;
    protected String localName = null;
    protected String prefix = null;
    protected ExpandedQName expandedName;
    protected double documentOrderVal = 0.0;
    protected boolean xpathBehavior = false;
    private boolean readonly = false;
    protected String baseURI = null;
    private int line;
    private int column;
    protected static int[] allowedChildren = new int[13];
    protected static final String xmlPrefix = "xml";
    protected static final String xmlnsPrefix = "xmlns";
    public static boolean toStringSerializes;

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    public void setNodeValue(String string) throws DOMException {
        switch (this.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.gateModify();
                this.nodeValue = string;
                break;
            }
        }
    }

    public abstract short getNodeType();

    public Node getParentNode() {
        return this.parentNode;
    }

    public NodeList getChildNodes() {
        return new ChildNodeList(this);
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.document;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        Node node3;
        this.gateModify();
        if (node == null || !(node instanceof NodeImpl) || node.getOwnerDocument() != this.document) {
            throw new DOMExceptionImpl(4, null);
        }
        if (node2 != null && ((node3 = node2.getParentNode()) == null || node3 != this)) {
            throw new DOMExceptionImpl(8, null);
        }
        if (node.getNodeType() == 11) {
            node3 = node.getFirstChild();
            while (node3 != null) {
                if (!this.isChildAllowed(node3)) {
                    throw new DOMExceptionImpl(3, null);
                }
                node3 = node3.getNextSibling();
            }
            while ((node3 = node.getFirstChild()) != null) {
                this.insertBefore(node3, node2);
            }
        } else {
            Attr attr;
            NodeImpl nodeImpl;
            if (!this.isChildAllowed(node)) {
                throw new DOMExceptionImpl(3, null);
            }
            node3 = this.getParentNode();
            while (node3 != null) {
                if (node3 == node) {
                    throw new DOMExceptionImpl(3, null);
                }
                node3 = node3.getParentNode();
            }
            NodeImpl nodeImpl2 = (NodeImpl)node;
            node3 = node.getParentNode();
            if (node3 != null) {
                node3.removeChild(nodeImpl2);
            }
            nodeImpl2.parentNode = this;
            nodeImpl2.previousSibling = nodeImpl = node2 == null ? this.lastChild : ((NodeImpl)node2).previousSibling;
            nodeImpl2.nextSibling = (NodeImpl)node2;
            if (nodeImpl != null) {
                nodeImpl.nextSibling = nodeImpl2;
                if (nodeImpl == this.lastChild) {
                    this.lastChild = nodeImpl2;
                }
            } else {
                this.firstChild = nodeImpl2;
                if (node2 == null) {
                    this.lastChild = nodeImpl2;
                }
            }
            if (node2 != null) {
                ((NodeImpl)node2).previousSibling = nodeImpl2;
            }
            if (nodeImpl2.getNodeType() == 1 && (attr = ((ElementImpl)nodeImpl2).getIdAttr()) != null) {
                this.document.addId((ElementImpl)nodeImpl2, attr.getNodeValue());
            }
            if (node3 == null) {
                nodeImpl2.purgeCachedExpandedNames();
            }
        }
        this.incChangeCount();
        return node;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.insertBefore(node, node2);
        return this.removeChild(node2);
    }

    public Node removeChild(Node node) throws DOMException {
        Attr attr;
        this.gateModify();
        Node node2 = node.getParentNode();
        if (node2 == null || node2 != this) {
            throw new DOMExceptionImpl(8, null);
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        nodeImpl.parentNode = null;
        if (this.firstChild == nodeImpl) {
            this.firstChild = nodeImpl.nextSibling;
        }
        if (this.lastChild == nodeImpl) {
            this.lastChild = nodeImpl.previousSibling;
        }
        if (nodeImpl.previousSibling != null) {
            nodeImpl.previousSibling.nextSibling = nodeImpl.nextSibling;
        }
        if (nodeImpl.nextSibling != null) {
            nodeImpl.nextSibling.previousSibling = nodeImpl.previousSibling;
        }
        nodeImpl.previousSibling = null;
        nodeImpl.nextSibling = null;
        this.incChangeCount();
        nodeImpl.purgeCachedExpandedNames();
        if (node.getNodeType() == 1 && (attr = ((ElementImpl)node).getIdAttr()) != null) {
            this.document.removeId(attr.getNodeValue());
        }
        return node;
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
        nodeImpl.parentNode = null;
        nodeImpl.firstChild = null;
        nodeImpl.lastChild = null;
        nodeImpl.previousSibling = null;
        nodeImpl.nextSibling = null;
        nodeImpl.readonly = false;
        if (bl) {
            Node node = this.getFirstChild();
            while (node != null) {
                nodeImpl.insertBefore(node.cloneNode(true), null);
                node = node.getNextSibling();
            }
        }
        return nodeImpl;
    }

    public void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 3 && node2 != null && node2.getNodeType() == 3) {
                ((Text)node).appendData(node2.getNodeValue());
                this.removeChild(node2);
                node2 = node;
            } else if (node.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = ((Element)((Object)this)).getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    namedNodeMap.item(n).normalize();
                    ++n;
                }
                ((Element)node).normalize();
            }
            node = node2;
        }
    }

    public boolean isSupported(String string, String string2) {
        return DOMImplementationImpl.checkFeature(string, string2);
    }

    public String getNamespaceURI() {
        if (this.localName == null && this.document.getSmartNS() && (this.getNodeType() == 1 || this.getNodeType() == 2)) {
            this.fetchNamespacesFromDecls(false);
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        if (this.localName == null && this.document.getSmartNS() && (this.getNodeType() == 1 || this.getNodeType() == 2)) {
            this.fetchNamespacesFromDecls(false);
        }
        return this.prefix;
    }

    public void setPrefix(String string) throws DOMException {
        this.gateModify();
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                String string2 = this.nodeName;
                int n = this.nodeName.indexOf(58);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                if (string != null) {
                    string2 = string + ":" + string2;
                }
                this.checkNameNS(this.namespaceURI, string2, this.getNodeType() == 2);
                this.prefix = string;
                this.nodeName = string2;
                break;
            }
        }
    }

    public String getLocalName() {
        if (this.localName == null && this.document.getSmartNS() && (this.getNodeType() == 1 || this.getNodeType() == 2)) {
            this.fetchNamespacesFromDecls(false);
        }
        return this.localName;
    }

    public boolean hasAttributes() {
        return this.getNodeType() == 1 && ((Element)((Object)this)).getAttributes().getLength() > 0;
    }

    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    public void setDeepReadOnly(boolean bl) {
        this.readonly = bl;
        Node node = this.getFirstChild();
        while (node != null) {
            ((NodeImpl)node).setDeepReadOnly(bl);
            node = node.getNextSibling();
        }
        NamedNodeMap namedNodeMap = this.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                ((NodeImpl)namedNodeMap.item(n)).setDeepReadOnly(bl);
                ++n;
            }
        }
    }

    public boolean isReadOnly() {
        return this.readonly || this.document.isLocked();
    }

    public int compareTo(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            Document document = this.getOwnerDocument();
            Document document2 = node.getOwnerDocument();
            if (document == null) {
                document = (Document)((Object)this);
            }
            if (document2 == null) {
                document2 = (Document)node;
            }
            if (node instanceof NodeImpl && document == document2) {
                ((DocumentImpl)document).updateDocumentOrder();
                double d = this.documentOrderVal - ((NodeImpl)node).documentOrderVal;
                return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
            }
            return DocumentOrderComparator.compareDocs(document, document2);
        }
        throw new ClassCastException();
    }

    public double getDocumentOrder() {
        return this.documentOrderVal;
    }

    public void setDocumentOrder(double d) {
        this.documentOrderVal = d;
    }

    public void setXPathBehavior(boolean bl) {
        this.xpathBehavior = bl;
    }

    public ExpandedQName getExpandedName() {
        if (this.expandedName == null) {
            short s = this.getNodeType();
            String string = this.getNodeName();
            this.setXPathBehavior(true);
            this.expandedName = s == 1 || s == 2 && !XMLUtil.isNamespaceDecl(string) ? new ExpandedQName(this) : new ExpandedQName("", string, "");
        }
        return this.expandedName;
    }

    public void setBaseURI(String string) throws DOMException {
        this.gateModify();
        this.baseURI = string;
    }

    public String getBaseURI() {
        if (this.baseURI == null) {
            NodeImpl nodeImpl = this.parentNode;
            while (nodeImpl != null && nodeImpl.baseURI == null) {
                nodeImpl = nodeImpl.parentNode;
            }
            return nodeImpl != null ? nodeImpl.baseURI : null;
        }
        return this.baseURI;
    }

    public void setColumnNumber(int n) {
        this.column = n;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public void setLineNumber(int n) {
        this.line = n;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String toString() {
        if (toStringSerializes) {
            try {
                StringWriter stringWriter = new StringWriter();
                DOMWriter dOMWriter = new DOMWriter(this, stringWriter);
                dOMWriter.write();
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getNodeName() + ',' + this.getNamespaceURI() + ',' + this.getNodeValue();
    }

    public boolean fetchNamespacesFromDecls(boolean bl) {
        Object object;
        Object object2;
        String string;
        boolean bl2 = false;
        boolean bl3 = false;
        short s = this.getNodeType();
        if (!(s != 2 && s != 1 || this.localName != null || (string = ((ExpandedQName)(object2 = this.getExpandedName())).getNamespaceURI()).equals("#{Unknown}#"))) {
            object = ((ExpandedQName)object2).getLocalPart();
            String string2 = ((ExpandedQName)object2).getPrefix();
            if (s == 2 && XMLUtil.isNamespaceDecl(this.nodeName)) {
                string = NamespaceName.XMLNS_NAMESPACE.getString();
            }
            try {
                string2 = string2.length() == 0 ? null : string2;
                string = string.length() == 0 ? null : string;
                this.checkNameNS(string, this.nodeName, s == 2);
                this.localName = object;
                this.prefix = string2;
                this.namespaceURI = string;
                bl2 = true;
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (bl) {
            switch (s) {
                case 1: {
                    object2 = this.getAttributes();
                    int n = 0;
                    while ((object = (AttrImpl)object2.item(n++)) != null) {
                        boolean bl4 = bl3 = ((NodeImpl)object).fetchNamespacesFromDecls(false) || bl3;
                    }
                }
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    object2 = this.getFirstChild();
                    while (object2 != null) {
                        bl3 = ((NodeImpl)object2).fetchNamespacesFromDecls(true) || bl3;
                        object2 = object2.getNextSibling();
                    }
                    break;
                }
            }
        }
        if (bl2 && !bl3) {
            this.incChangeCount();
        }
        return bl2 || bl3;
    }

    protected NodeImpl(DocumentImpl documentImpl, String string, String string2) {
        this.document = documentImpl == null && this instanceof DocumentImpl ? (DocumentImpl)this : documentImpl;
        this.nodeName = string;
        this.nodeValue = string2;
    }

    protected NodeImpl(DocumentImpl documentImpl, String string, String string2, String string3) {
        this.document = documentImpl == null ? (DocumentImpl)this : documentImpl;
        this.namespaceURI = string;
        this.nodeName = string2;
        int n = this.nodeName.indexOf(58);
        if (n != -1) {
            this.prefix = this.nodeName.substring(0, n);
            this.localName = this.nodeName.substring(n + 1);
        } else {
            this.localName = string2;
        }
        this.nodeValue = string3;
    }

    protected boolean isChildAllowed(Node node) {
        return (allowedChildren[this.getNodeType()] & 1 << node.getNodeType()) != 0;
    }

    protected void incChangeCount() {
        ++this.changeCount;
        if (this.parentNode != null) {
            this.parentNode.incChangeCount();
        }
    }

    protected int getChangeCount() {
        return this.changeCount;
    }

    protected void gateModify() throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7, null);
        }
    }

    protected void checkName(String string) throws DOMException {
        if (this.document.checkNames() && !XMLUtil.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
    }

    protected void checkNameNS(String string, String string2, boolean bl) throws DOMException {
        this.checkName(string2);
        if (this.document.checkNames()) {
            if (!XMLUtil.isQName(string2)) {
                throw new DOMExceptionImpl(14, null);
            }
            int n = string2.indexOf(58);
            if (n != -1) {
                if (string == null) {
                    throw new DOMExceptionImpl(14, null);
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (string3.equals(xmlPrefix) && !string.equals(NamespaceName.XML_NAMESPACE.getString())) {
                    throw new DOMExceptionImpl(14, null);
                }
                if (bl && (string3.equals(xmlnsPrefix) && !string.equals(NamespaceName.XMLNS_NAMESPACE.getString()) || string4.equals(xmlnsPrefix))) {
                    throw new DOMExceptionImpl(14, null);
                }
            } else {
                if (!XMLUtil.isNCName(string2)) {
                    throw new DOMExceptionImpl(14, null);
                }
                if (!(!bl || string == null || string2.equals(xmlnsPrefix) && string.equals(NamespaceName.XMLNS_NAMESPACE.getString()))) {
                    throw new DOMExceptionImpl(14, null);
                }
            }
        }
    }

    protected void setOwnerDocument(DocumentImpl documentImpl) throws DOMException {
        if (this.getNodeType() != 10) {
            throw new DOMExceptionImpl(4, null);
        }
        this.document = documentImpl;
    }

    protected void purgeCachedExpandedNames() {
        this.expandedName = null;
        NodeImpl nodeImpl = this.firstChild;
        while (nodeImpl != null) {
            nodeImpl.purgeCachedExpandedNames();
            nodeImpl = nodeImpl.nextSibling;
        }
    }

    static {
        NodeImpl.allowedChildren[1] = 442;
        NodeImpl.allowedChildren[2] = 40;
        NodeImpl.allowedChildren[3] = 0;
        NodeImpl.allowedChildren[4] = 0;
        NodeImpl.allowedChildren[5] = allowedChildren[1];
        NodeImpl.allowedChildren[6] = allowedChildren[1];
        NodeImpl.allowedChildren[7] = 0;
        NodeImpl.allowedChildren[8] = 0;
        NodeImpl.allowedChildren[9] = 410;
        NodeImpl.allowedChildren[10] = 0;
        NodeImpl.allowedChildren[11] = allowedChildren[1];
        NodeImpl.allowedChildren[12] = 0;
        toStringSerializes = false;
    }
}

