/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class BooleanValue
implements ExpressionValue,
Expression {
    private boolean value;
    private static final Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.BooleanValue");

    public BooleanValue(boolean bl) {
        this.value = bl;
    }

    public BooleanValue() {
        this.value = false;
    }

    public static Class getArgType() {
        return argType;
    }

    public String toString() {
        return this.getStringValue();
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return BooleanValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }

    public int getValueType() {
        return 0;
    }

    public void castFrom(Object object) throws XPathConversionException {
        if (object instanceof ExpressionValue) {
            this.value = ((ExpressionValue)object).getBooleanValue();
        } else if (object instanceof Boolean) {
            this.value = (Boolean)object;
        } else {
            throw new XPathConversionException("vce3", object.getClass().getName());
        }
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return this.value;
    }

    public double getNumberValue() throws XPathConversionException {
        return this.value ? 1.0 : 0.0;
    }

    public String getStringValue() {
        return this.value ? "true" : "false";
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        throw new XPathConversionException("vce1");
    }

    public Object getNativeValue() {
        return new Boolean(this.value);
    }

    public void dump(PrintWriter printWriter) {
        try {
            printWriter.println(this.getStringValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void not() {
        this.value = !this.value;
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object object) {
        if (object instanceof BooleanValue) {
            return this.value == ((BooleanValue)object).value;
        }
        if (object instanceof Boolean) {
            return this.value == (Boolean)object;
        }
        return false;
    }
}

