/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import java.math.BigDecimal;
import org.w3c.dom.Node;

public class FunctionCall
implements Expression {
    private ExpressionValue[] nullArgs = new ExpressionValue[0];
    private Function function;
    private ArgumentList args;
    private int[] argType;
    private Object[] argFrame;
    private DoubleCaster[] argCaster;
    boolean passContext = false;
    private static final Class interfaceExpressionValue = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
    private static final Class classString = XPathUtil.doGetClass("java.lang.String");
    private static final Class classNumber = XPathUtil.doGetClass("java.lang.Number");
    private static final Class classBigDecimal = XPathUtil.doGetClass("java.math.BigDecimal");
    private static final Class classBigInteger = XPathUtil.doGetClass("java.math.BigInteger");
    private static final Class classDouble = XPathUtil.doGetClass("java.lang.Double");
    private static final Class classFloat = XPathUtil.doGetClass("java.lang.Float");
    private static final Class classLong = XPathUtil.doGetClass("java.lang.Long");
    private static final Class classInteger = XPathUtil.doGetClass("java.lang.Integer");
    private static final Class classShort = XPathUtil.doGetClass("java.lang.Short");
    private static final Class classByte = XPathUtil.doGetClass("java.lang.Byte");
    private static final Class classBoolean = XPathUtil.doGetClass("java.lang.Boolean");
    private static final int TYPE_CORRECT = 0;
    private static final int TYPE_EXPRESSION_VALUE = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_NUMBER = 3;
    private static final int TYPE_STRING = 4;
    private static final int TYPE_NATIVE = 5;

    public FunctionCall(Function function) throws XPathParserException {
        this.args = new ArgumentList();
        this.function = function.getInstance(this.args);
        this.argFrame = null;
        this.argCaster = null;
        this.argType = null;
    }

    public FunctionCall(Function function, ArgumentList argumentList) throws XPathParserException {
        this.args = argumentList == null ? new ArgumentList() : argumentList;
        this.function = function.getInstance(this.args);
        this.setupArgs();
    }

    public Function getFunction() {
        return this.function;
    }

    public String toString() {
        return this.function.toString() + "(" + this.args.toString() + ")";
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        ExpressionValue[] expressionValueArray = this.args.count() > 0 ? this.args.evaluate(node, expressionContext) : this.nullArgs;
        this.frameArguments(expressionValueArray, node, expressionContext);
        return this.function.invoke(this.argFrame);
    }

    public boolean isConstant() {
        return this.function.isConstant();
    }

    public Class getResultType() {
        return this.function.getSignature().getReturnType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
        this.function.registerForReset(xPathResetRegistrar);
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }

    protected void frameArguments(ExpressionValue[] expressionValueArray, Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        int n = 0;
        if (this.passContext) {
            this.argFrame[0] = node;
            this.argFrame[1] = expressionContext;
            n = 2;
        }
        int n2 = 0;
        while (n2 < expressionValueArray.length) {
            if (this.argType[n2] == 0) {
                this.argFrame[n2 + n] = expressionValueArray[n2];
            } else if (this.argType[n2] == 1) {
                ((ExpressionValue)this.argFrame[n2 + n]).castFrom(expressionValueArray[n2]);
            } else if (this.argType[n2] == 2) {
                this.argFrame[n2 + n] = new Boolean(expressionValueArray[n2].getBooleanValue());
            } else if (this.argType[n2] == 3) {
                this.argFrame[n2 + n] = this.argCaster[n2 + n].cast(expressionValueArray[n2].getNumberValue());
            } else if (this.argType[n2] == 4) {
                this.argFrame[n2 + n] = expressionValueArray[n2].getStringValue();
            } else if (this.argType[n2] == 5) {
                this.argFrame[n2 + n] = expressionValueArray[n2].getNativeValue();
            }
            ++n2;
        }
    }

    protected void setupArgs() throws XPathParserException {
        int n = 0;
        try {
            FunctionSignature functionSignature = this.function.getSignature();
            Class[] classArray = functionSignature.getRequiredArgs();
            Class[] classArray2 = functionSignature.getOptionalArgs();
            Class[] classArray3 = FunctionSignature.getContextArgTypes();
            int n2 = 0;
            if (classArray.length >= 2 && classArray[0] == classArray3[0] && classArray[1] == classArray3[1]) {
                n2 = 2;
                this.passContext = true;
            }
            this.argFrame = new Object[this.args.count() + (this.passContext ? 2 : 0)];
            this.argCaster = new DoubleCaster[this.argFrame.length];
            this.argType = new int[this.argFrame.length];
            if (this.passContext) {
                this.argType[0] = 0;
                this.argType[1] = 0;
            }
            n = n2;
            while (n < classArray.length && n - n2 < this.args.count()) {
                if (!classArray[n].isAssignableFrom(this.args.getArgument(n - n2).getResultType())) {
                    FunctionCall.argConversion(this.argFrame, this.argCaster, this.argType, n, classArray, n);
                } else {
                    this.argType[n] = 0;
                }
                ++n;
            }
            if (n < classArray.length) {
                throw new XPathParserException("pe9");
            }
            if (n - n2 < this.args.count() && classArray2.length != 0) {
                int n3 = 0;
                while (n3 < classArray2.length && n - n2 < this.args.count()) {
                    if (!classArray2[n3].isAssignableFrom(this.args.getArgument(n - n2).getResultType())) {
                        FunctionCall.argConversion(this.argFrame, this.argCaster, this.argType, n, classArray2, n3);
                    } else {
                        this.argType[n] = 0;
                    }
                    ++n;
                    ++n3;
                }
            }
            if (n - n2 < this.args.count()) {
                throw new XPathParserException("pe10");
            }
            return;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String[] stringArray = new String[]{Integer.toString(n + 1), this.function.getSignature().getName().getQName()};
        throw new XPathParserException("pe11", stringArray);
    }

    private static void argConversion(Object[] objectArray, DoubleCaster[] doubleCasterArray, int[] nArray, int n, Class[] classArray, int n2) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        if (Boolean.TYPE.isAssignableFrom(classArray[n2]) || classBoolean.isAssignableFrom(classArray[n2])) {
            nArray[n] = 2;
        } else if (classArray[n2].isPrimitive() || classNumber.isAssignableFrom(classArray[n2])) {
            nArray[n] = 3;
            doubleCasterArray[n] = new NumberCaster(classArray[n2]);
        } else if (classString.isAssignableFrom(classArray[n2])) {
            nArray[n] = 4;
        } else if (interfaceExpressionValue.isAssignableFrom(classArray[n2])) {
            objectArray[n] = classArray[n2].newInstance();
            nArray[n] = 1;
        } else {
            nArray[n] = 5;
        }
    }

    protected static class NumberCaster
    implements DoubleCaster {
        protected DoubleCaster caster;

        public NumberCaster(Class clazz) throws IllegalArgumentException {
            if (clazz.isAssignableFrom(Double.TYPE) || clazz.isAssignableFrom(classDouble)) {
                this.caster = new toDouble();
            } else if (clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(classFloat)) {
                this.caster = new toFloat();
            } else if (clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(classLong)) {
                this.caster = new toLong();
            } else if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(classInteger)) {
                this.caster = new toInteger();
            } else if (clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(classShort)) {
                this.caster = new toShort();
            } else if (clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(classByte)) {
                this.caster = new toByte();
            } else if (clazz.isAssignableFrom(classBigDecimal)) {
                this.caster = new toBigDecimal();
            } else if (clazz.isAssignableFrom(classBigInteger)) {
                this.caster = new toBigInteger();
            } else {
                throw new IllegalArgumentException();
            }
        }

        public Number cast(double d) {
            return this.caster.cast(d);
        }

        private static class toBigInteger
        implements DoubleCaster {
            private toBigInteger() {
            }

            public Number cast(double d) {
                return new BigDecimal(d).toBigInteger();
            }
        }

        private static class toBigDecimal
        implements DoubleCaster {
            private toBigDecimal() {
            }

            public Number cast(double d) {
                return new BigDecimal(d);
            }
        }

        private static class toByte
        implements DoubleCaster {
            private toByte() {
            }

            public Number cast(double d) {
                return new Byte((byte)d);
            }
        }

        private static class toShort
        implements DoubleCaster {
            private toShort() {
            }

            public Number cast(double d) {
                return new Short((short)d);
            }
        }

        private static class toInteger
        implements DoubleCaster {
            private toInteger() {
            }

            public Number cast(double d) {
                return new Integer((int)d);
            }
        }

        private static class toLong
        implements DoubleCaster {
            private toLong() {
            }

            public Number cast(double d) {
                return new Long((long)d);
            }
        }

        private static class toFloat
        implements DoubleCaster {
            private toFloat() {
            }

            public Number cast(double d) {
                return new Float((float)d);
            }
        }

        private static class toDouble
        implements DoubleCaster {
            private toDouble() {
            }

            public Number cast(double d) {
                return new Double(d);
            }
        }
    }

    protected static interface DoubleCaster {
        public Number cast(double var1);
    }
}

