/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Scanner;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import java.math.BigDecimal;
import org.w3c.dom.Node;

public class NumberValue
implements ExpressionValue,
Expression,
Comparable {
    private double value;
    private static final Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.NumberValue");

    public NumberValue(double d) {
        this.value = d;
    }

    public NumberValue() {
        this.value = Double.NaN;
    }

    public static Class getArgType() {
        return argType;
    }

    public String toString() {
        return this.getStringValue();
    }

    public static double convertToNumber(String string) {
        String string2 = string.trim();
        if (string2.length() < 1) {
            return Double.NaN;
        }
        boolean bl = false;
        if (string2.charAt(0) == '-') {
            string2 = string2.substring(1, string2.length());
            bl = true;
        }
        double d = Scanner.scanNumber(string2);
        if (bl && !Double.isNaN(d)) {
            d = -d;
        }
        return d;
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return NumberValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }

    public int getValueType() {
        return 1;
    }

    public void castFrom(Object object) throws XPathConversionException {
        this.value = object instanceof ExpressionValue ? ((ExpressionValue)object).getNumberValue() : (object instanceof Number ? ((Number)object).doubleValue() : NumberValue.convertToNumber(object.toString()));
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return this.value != 0.0 && this.value != -0.0 && !Double.isNaN(this.value);
    }

    public double getNumberValue() throws XPathConversionException {
        return this.value;
    }

    public String getStringValue() {
        return NumberValue.getStringValue(this.value);
    }

    public static String getStringValue(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        if (Math.floor(d) == d) {
            return new BigDecimal(d).toBigInteger().toString();
        }
        if (0.001 <= d && d < 1.0E7 || -0.001 >= d && d > -1.0E7) {
            return Double.toString(d);
        }
        boolean bl = d < 0.0;
        String string = Double.toString(bl ? -d : d);
        int n = string.indexOf(69);
        if (n == -1) {
            return bl ? "-" + string : string;
        }
        int n2 = Integer.valueOf(string.substring(n + 1, string.length()));
        String string2 = string.substring(0, n);
        int n3 = n2 < 0 ? Math.abs(n2) - 1 + string2.length() : Math.max(n2 - 1, string2.length());
        StringBuffer stringBuffer = new StringBuffer(n3);
        if (bl) {
            stringBuffer.append('-');
        }
        if (n2 < 0) {
            stringBuffer.append('0');
            stringBuffer.append('.');
            int n4 = 0;
            while (n4 < Math.abs(n2) - 1) {
                stringBuffer.append('0');
                ++n4;
            }
            stringBuffer.append(string2.charAt(0));
            if (string2.length() > 3 || string2.charAt(2) != '0') {
                stringBuffer.append(string2.substring(2, string2.length()));
            }
        } else {
            stringBuffer.append(string2.charAt(0));
            stringBuffer.append(string2.substring(2, 2 + n2));
            stringBuffer.append('.');
            stringBuffer.append(string2.substring(2 + n2, string2.length()));
        }
        return stringBuffer.toString();
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        throw new XPathConversionException("vce1");
    }

    public Object getNativeValue() {
        return new Double(this.value);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println(this.getStringValue());
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof NumberValue) {
            return Double.doubleToLongBits(((NumberValue)object).value) == Double.doubleToLongBits(this.value);
        }
        if (object instanceof Double) {
            return Double.doubleToLongBits((Double)object) == Double.doubleToLongBits(this.value);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof NumberValue) {
            return Double.compare(this.value, ((NumberValue)object).value);
        }
        return Double.compare(this.value, (Double)object);
    }
}

