/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.functions;

import com.novell.xml.dom.NodeImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.process.Context;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class xsltDocument
extends Function
implements XPathResetCache {
    private XMLParser xmlParser = null;
    private StringBuffer errorBuffer = null;
    private Map documentMap = null;
    private Document cachedStylesheet = null;

    public xsltDocument() {
        super(xsltDocument.createSignature());
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        try {
            Context context = (Context)objectArray[1];
            ExpressionValue expressionValue = (ExpressionValue)objectArray[2];
            NodeSet nodeSet = objectArray.length > 3 ? ((ExpressionValue)objectArray[3]).getNodeSetValue() : null;
            NodeSet nodeSet2 = new NodeSet();
            if (this.documentMap == null) {
                this.documentMap = new HashMap();
            }
            if (this.xmlParser == null) {
                this.xmlParser = XMLParserFactory.newParser();
            }
            if (this.errorBuffer != null) {
                this.errorBuffer.setLength(0);
            }
            if (expressionValue.getValueType() == 3) {
                NodeSet nodeSet3 = expressionValue.getNodeSetValue();
                Node node = nodeSet3.first();
                while (node != null) {
                    String string = XPathUtil.getNodeValue(node);
                    boolean bl = string != null && string.length() == 0;
                    URL uRL = this.getURL(string, nodeSet, node, context);
                    Document document = (Document)this.documentMap.get(uRL.toString());
                    if (document != null || bl && (document = this.cachedStylesheet) != null) {
                        nodeSet2.add(document);
                    } else {
                        this.xmlParser.setContextURI(uRL.toString());
                        document = this.xmlParser.parse(uRL.openStream());
                        if (this.xmlParser.anyErrors()) {
                            this.packageErrors(this.xmlParser);
                        } else {
                            if (context.getStylesheet().getXmlHook() != null) {
                                document = context.getStylesheet().getXmlHook().processDocument(document);
                            }
                            nodeSet2.add(document);
                            context.addBaseURI(document, uRL);
                            if (bl) {
                                this.cachedStylesheet = document;
                            } else {
                                this.documentMap.put(uRL.toString(), document);
                            }
                        }
                    }
                    node = nodeSet3.next();
                }
            } else {
                String string = expressionValue.getStringValue();
                boolean bl = string != null && string.length() == 0;
                URL uRL = this.getURL(string, nodeSet, context.getCurrentStylesheetNode(), context);
                Document document = (Document)this.documentMap.get(uRL.toString());
                if (document != null || bl && (document = this.cachedStylesheet) != null) {
                    nodeSet2.add(document);
                } else {
                    this.xmlParser.setContextURI(uRL.toString());
                    document = this.xmlParser.parse(uRL.openStream());
                    if (this.xmlParser.anyErrors()) {
                        this.packageErrors(this.xmlParser);
                    } else {
                        if (context.getStylesheet().getXmlHook() != null) {
                            document = context.getStylesheet().getXmlHook().processDocument(document);
                        }
                        nodeSet2.add(document);
                        context.addBaseURI(document, uRL);
                        if (bl) {
                            this.cachedStylesheet = document;
                        } else {
                            this.documentMap.put(uRL.toString(), document);
                        }
                    }
                }
            }
            if (this.errorBuffer != null && this.errorBuffer.length() > 0) {
                throw new XPathEvaluationException(this.toString() + "(): " + this.errorBuffer.toString());
            }
            return nodeSet2;
        }
        catch (ClassCastException classCastException) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XPathEvaluationException("pe9");
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathEvaluationException(this.toString() + "(): " + malformedURLException.toString());
        }
        catch (IOException iOException) {
            throw new XPathEvaluationException(this.toString() + "(): " + iOException.toString());
        }
        catch (Exception exception) {
            throw new XPathEvaluationException(this.toString() + "(): " + exception.toString());
        }
    }

    private URL getURL(String string, NodeSet nodeSet, Node node, Context context) throws MalformedURLException {
        node = nodeSet == null ? node : nodeSet.first();
        String string2 = null;
        if (node instanceof NodeImpl) {
            string2 = ((NodeImpl)node).getBaseURI();
        }
        URL uRL = string2 != null && string2.length() > 0 ? new URL(string2) : context.getBaseURI(node);
        if (string.length() > 0) {
            if (uRL != null) {
                return new URL(uRL, string);
            }
            return new URL(string);
        }
        return uRL;
    }

    private void packageErrors(XMLParser xMLParser) {
        if (this.errorBuffer == null) {
            this.errorBuffer = new StringBuffer(128);
        }
        this.errorBuffer.append(xMLParser.getErrorMsgString());
    }

    public String toString() {
        return "document";
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
        xPathResetRegistrar.registerResetCache(this);
    }

    public void resetCache() {
        this.documentMap = null;
    }

    private static FunctionSignature createSignature() {
        try {
            Class[] classArray = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], Class.forName("com.novell.xml.xpath.ExpressionValue")};
            Class[] classArray2 = new Class[]{NodeSet.getArgType()};
            return new FunctionSignature(new ExpandedQName("", "document"), NodeSet.getArgType(), classArray, classArray2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.getLocalizedMessage());
        }
    }
}

