/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.ForEachTemplate;
import com.novell.xsl.process.SortCriteria;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.process.Template;
import com.novell.xsl.util.Util;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ForEachParser {
    private static AttrDef[] forEachAttr = new AttrDef[]{new AttrDef("select", 1, null, 8)};

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] objectArray = AttrDef.parseAttributes(stylesheetParser, element, forEachAttr);
        if (objectArray[0] == null) {
            return null;
        }
        Expression expression = (Expression)objectArray[0];
        Node[] nodeArray = new Node[]{element.getFirstChild()};
        SortCriteria sortCriteria = ForEachParser.parseSort(stylesheetParser, nodeArray);
        Template[] templateArray = stylesheetParser.parseTemplates(nodeArray[0], true);
        return new ForEachTemplate(expression, templateArray, sortCriteria, element);
    }

    private static SortCriteria parseSort(StylesheetParser stylesheetParser, Node[] nodeArray) throws XSLTParserException {
        SortKey[] sortKeyArray;
        ArrayList<SortKey> arrayList = new ArrayList<SortKey>();
        Node node = nodeArray[0];
        block5: while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    sortKeyArray = (SortKey[])node;
                    ExpandedQName expandedQName = DOMUtil.getExpandedName((Node)sortKeyArray);
                    if (!expandedQName.namespaceNameEquals(Stylesheet.NAMESPACE) || !expandedQName.localPartEquals("sort")) break block5;
                    stylesheetParser.pushNSContext((Node)sortKeyArray);
                    arrayList.add(stylesheetParser.parseSortElement((Element)sortKeyArray));
                    stylesheetParser.popNSContext();
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    if (Util.stripWhitespaceNode(node)) break;
                    break block5;
                }
                default: {
                    break block5;
                }
            }
            node = node.getNextSibling();
        }
        nodeArray[0] = node;
        if (arrayList.size() == 0) {
            return null;
        }
        sortKeyArray = new SortKey[arrayList.size()];
        arrayList.toArray(sortKeyArray);
        return new SortCriteria(sortKeyArray, nodeArray[0].getParentNode());
    }
}

