/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.TextResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class AttributeTemplate
extends TemplateCollection {
    private final Expression name;
    private final Expression namespace;
    private final int importance;
    private final int position;

    public AttributeTemplate(Expression expression, Expression expression2, Template[] templateArray, int n, int n2, Node node) {
        super(templateArray, node);
        this.name = expression;
        this.namespace = expression2;
        this.importance = n;
        this.position = n2;
    }

    public Expression getNameExpression() {
        return this.name;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public int getPosition() {
        return this.position;
    }

    public int getImportance() {
        return this.importance;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("attribute");
        String string = null;
        try {
            int n;
            string = processingEnv.getContext().evaluate(node, this.name).getStringValue();
            if (!XMLUtil.isQName(string)) {
                processingEnv.reportError(this.getNamespaceContext(), "pe5", string);
            }
            String string2 = (n = string.indexOf(58)) != -1 ? string.substring(0, n) : "";
            NamespaceName namespaceName = null;
            if (this.namespace == null) {
                if (string2.length() > 0) {
                    namespaceName = processingEnv.getContext().getNamespaceName(string2);
                }
            } else {
                namespaceName = new NamespaceName(processingEnv.getContext().evaluate(node, this.namespace).getStringValue());
            }
            if (string2.equals("xmlns")) {
                string2 = "_" + string2;
                string = string2 + string.substring(n, string.length());
            }
            TextResultHandler textResultHandler = new TextResultHandler();
            this.instantiateTemplates(processingEnv, node, textResultHandler);
            String string3 = textResultHandler.getText();
            if (namespaceName != null && !namespaceName.isEmpty()) {
                ProcessingEnv.resultNamespace(resultHandler, string2, namespaceName);
            }
            resultHandler.attribute(string, string3);
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
        catch (AttributeAfterChildException attributeAfterChildException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe6", string);
        }
        catch (IllegalNameException illegalNameException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe5", string);
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7", string);
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("attribute");
        Util.indent(printWriter, n + 1);
        printWriter.println("name");
        this.name.dump(printWriter, n + 2);
        super.dump(printWriter, n);
    }
}

