/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisDescendantOrSelf;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.SingleNodeList;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class Key
implements XPathResetCache {
    private ExpandedQName name;
    private Pattern match;
    private Expression use;
    private Node namespaceContext;
    private Axis axis = null;
    private SingleNodeList nodeList = null;
    private Map cacheMap = null;

    public Key(ExpandedQName expandedQName, Pattern pattern, Expression expression, Node node) {
        this.name = expandedQName;
        this.match = pattern;
        this.use = expression;
        this.namespaceContext = node;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet evaluate(String string, Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        NodeSet nodeSet;
        Node node2 = node.getOwnerDocument();
        Node node3 = node2 = node2 == null ? node : node2;
        if (this.axis == null) {
            this.axis = new AxisDescendantOrSelf();
        }
        if ((nodeSet = this.getCachedResult(node2, string)) != null) {
            return nodeSet;
        }
        if (this.nodeList == null) {
            this.nodeList = new SingleNodeList();
        }
        expressionContext.pushState();
        try {
            ExpressionValue expressionValue;
            expressionContext.setNamespaceContext(this.namespaceContext);
            this.axis.setup(node2, expressionContext);
            nodeSet = new NodeSet();
            Node node4 = this.axis.first();
            while (node4 != null) {
                if (this.match.match(node4, expressionContext)) {
                    this.nodeList.setNode(node4);
                    expressionContext.setContextNodeList(this.nodeList);
                    expressionValue = this.use.evaluate(node4, expressionContext);
                    if (expressionValue.getValueType() == 3) {
                        NodeSet nodeSet2 = expressionValue.getNodeSetValue();
                        Node node5 = nodeSet2.first();
                        while (node5 != null) {
                            if (string.equals(XPathUtil.getNodeValue(node5))) {
                                nodeSet.add(node4);
                                break;
                            }
                            node5 = nodeSet2.next();
                        }
                    } else if (string.equals(expressionValue.getStringValue())) {
                        nodeSet.add(node4);
                    }
                }
                node4 = this.axis.next();
            }
            this.cacheResult(node2, string, nodeSet);
            expressionValue = nodeSet;
            Object var11_10 = null;
            expressionContext.popState();
            return expressionValue;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            expressionContext.popState();
            throw throwable;
        }
    }

    public void resetCache() {
        this.cacheMap = null;
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.print("Key: '");
        printWriter.print(this.name.getQName());
        printWriter.println('\'');
        this.match.dump(printWriter, n + 1);
        this.use.dump(printWriter, n + 1);
    }

    private void cacheResult(Node node, String string, NodeSet nodeSet) {
        if (this.cacheMap == null) {
            this.cacheMap = new HashMap();
        }
        this.cacheMap.put(new CacheKey(node, string), nodeSet);
    }

    private NodeSet getCachedResult(Node node, String string) {
        if (this.cacheMap != null) {
            return (NodeSet)this.cacheMap.get(new CacheKey(node, string));
        }
        return null;
    }

    private static class CacheKey {
        private final int hash;
        private final Node document;
        private final String value;

        public CacheKey(Node node, String string) {
            int n = string.hashCode();
            int n2 = n >> 24 & 0xFF;
            this.hash = node.hashCode() * 37 + string.hashCode() | n2;
            this.document = node;
            this.value = string;
        }

        public boolean equals(Object object) {
            return object instanceof CacheKey && this.document.equals(((CacheKey)object).document) && this.value.equals(((CacheKey)object).value);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

