/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.number.NumberFormatter;
import com.novell.xsl.number.NumberFormatters;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Node;

public abstract class NumberTemplate
implements Template {
    protected Pattern countPattern;
    protected Pattern fromPattern;
    protected Expression formatExpr;
    protected Expression langExpr;
    protected Expression letterValueExpr;
    protected Expression digitGroupSepExpr;
    protected Expression digitsPerGroupExpr;
    protected Expression valueExpr;
    protected ParsedFormat preparsedFormat;
    private Node nsContext;

    public NumberTemplate(Pattern pattern, Pattern pattern2, Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Expression expression6, Node node) throws XSLException {
        this.countPattern = pattern;
        this.fromPattern = pattern2;
        this.formatExpr = expression;
        this.langExpr = expression2;
        this.letterValueExpr = expression3;
        this.digitGroupSepExpr = expression4;
        this.digitsPerGroupExpr = expression5;
        this.valueExpr = expression6;
        this.nsContext = node;
        if (expression.isConstant() && (expression2 == null || expression2.isConstant()) && (expression3 == null || expression3.isConstant())) {
            try {
                String string = expression.evaluate(null, null).getStringValue();
                String string2 = expression2 == null ? null : expression2.evaluate(null, null).getStringValue();
                String string3 = expression3 == null ? null : expression3.evaluate(null, null).getStringValue();
                this.preparsedFormat = new ParsedFormat(string, string2, string3);
            }
            catch (XPathEvaluationException xPathEvaluationException) {
                StringBuffer stringBuffer = ProcessingEnv.buildMsgPrologue(null, node);
                stringBuffer.append(xPathEvaluationException.getMessage());
                throw new XSLException(stringBuffer.toString());
            }
        } else {
            this.preparsedFormat = null;
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter printWriter, int n) {
        if (this.countPattern != null) {
            printWriter.println(n + "count");
            this.countPattern.dump(printWriter, n + 1);
        }
        if (this.fromPattern != null) {
            printWriter.println(n + "from");
            this.fromPattern.dump(printWriter, n + 1);
        }
        printWriter.println(n + "format");
        this.formatExpr.dump(printWriter, n + 1);
        if (this.langExpr != null) {
            printWriter.println(n + "xml:lang");
            this.langExpr.dump(printWriter, n + 1);
        }
        if (this.letterValueExpr != null) {
            printWriter.println(n + "letterValue");
            this.letterValueExpr.dump(printWriter, n + 1);
        }
        if (this.digitGroupSepExpr != null) {
            printWriter.println(n + "digitGroupSep");
            this.digitGroupSepExpr.dump(printWriter, n + 1);
        }
        if (this.digitsPerGroupExpr != null) {
            printWriter.println(n + "digitsPerGroup");
            this.digitsPerGroupExpr.dump(printWriter, n + 1);
        }
        if (this.valueExpr != null) {
            printWriter.println(n + "value");
            this.valueExpr.dump(printWriter, n + 1);
        }
        if (this.preparsedFormat != null) {
            printWriter.println(n + "preparsedFormat");
            this.preparsedFormat.dump(printWriter, n + 1);
        }
    }

    protected static final class ParsedFormat {
        private String start;
        private final String end;
        private final NumberFormatter[] formatters;
        private final String[] separators;

        /*
         * Unable to fully structure code
         */
        public ParsedFormat(String var1_1, String var2_2, String var3_3) throws XSLException {
            block8: {
                super();
                var4_4 = new ArrayList<NumberFormatter>();
                var5_5 = new ArrayList<String>();
                var6_6 = var1_1.toCharArray();
                var7_7 = 0;
                var8_8 = 0;
                while (var7_7 < var6_6.length && !ParsedFormat.isAlphanumeric(var6_6[var7_7])) {
                    ++var7_7;
                }
                if (var7_7 == var8_8) {
                    this.start = null;
                } else {
                    this.start = var1_1.substring(var8_8, var7_7);
                    var8_8 = var7_7;
                }
                var5_5.add(".");
                if (var7_7 != var6_6.length) ** GOTO lbl24
                var4_4.add(NumberFormatters.get("1", var2_2, var3_3));
                this.end = this.start;
                this.start = null;
                break block8;
                {
                    ++var7_7;
lbl24:
                    // 2 sources

                    while (true) {
                        if (var7_7 < var6_6.length && ParsedFormat.isAlphanumeric(var6_6[var7_7])) continue block1;
                        var4_4.add(NumberFormatters.get(var1_1.substring(var8_8, var7_7), var2_2, var3_3));
                        var8_8 = var7_7;
                        while (var7_7 < var6_6.length && !ParsedFormat.isAlphanumeric(var6_6[var7_7])) {
                            ++var7_7;
                        }
                        if (var7_7 == var6_6.length) {
                            if (var7_7 == var8_8) {
                                this.end = null;
                                break block1;
                            }
                            this.end = var1_1.substring(var8_8, var7_7);
                            break block1;
                        }
                        var5_5.add(var1_1.substring(var8_8, var7_7));
                        var8_8 = var7_7;
                    }
                }
            }
            this.formatters = new NumberFormatter[var4_4.size()];
            var4_4.toArray(this.formatters);
            this.separators = new String[var5_5.size()];
            var5_5.toArray(this.separators);
            Assert.assertCondition(this.formatters.length == this.separators.length, "formatters and separators out-of-sync");
        }

        private static boolean isAlphanumeric(char c) {
            switch (Character.getType(c)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }

        public void formatStart(ResultHandler resultHandler) throws IllegalNodeException, ResultException {
            if (this.start != null) {
                resultHandler.characters(this.start);
            }
        }

        public void formatNumber(int n, int n2, String string, int n3, ResultHandler resultHandler) throws IllegalNodeException, ResultException {
            if (n2 > 0) {
                if (n2 >= this.separators.length) {
                    n2 = this.separators.length - 1;
                }
                resultHandler.characters(this.separators[n2]);
            }
            String string2 = this.formatters[n2].format(n);
            if (string != null && string2.length() > n3) {
                char[] cArray = string2.toCharArray();
                int n4 = string2.length();
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = (n4 - 1) % n3 + 1;
                stringBuffer.append(cArray, 0, n5);
                do {
                    stringBuffer.append(string).append(cArray, n5, n3);
                } while ((n5 += n3) < n4);
                string2 = stringBuffer.toString();
            }
            resultHandler.characters(string2);
        }

        public void formatEnd(ResultHandler resultHandler) throws IllegalNodeException, ResultException {
            if (this.end != null) {
                resultHandler.characters(this.end);
            }
        }

        public void dump(PrintWriter printWriter, int n) {
            if (this.start != null) {
                Util.indent(printWriter, n);
                printWriter.println(XMLUtil.quote(this.start));
            }
            int n2 = 1;
            while (n2 < this.separators.length) {
                Util.indent(printWriter, n);
                printWriter.println(XMLUtil.quote(this.separators[n2]));
                Util.indent(printWriter, n);
                printWriter.println(this.formatters[n2].getClass().getName());
                ++n2;
            }
            Util.indent(printWriter, n);
            printWriter.println(this.formatters[this.formatters.length].getClass().getName());
            if (this.end != null) {
                Util.indent(printWriter, n);
                printWriter.println(XMLUtil.quote(this.end));
            }
        }
    }
}

