/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.util;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.Stylesheet;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Util {
    public static final String SPACE_DEFAULT = "default";
    public static final String SPACE_PRESERVE = "preserve";

    private Util() {
    }

    public static String getXSLStringValue(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                return Util.getElementStringValue(node);
            }
        }
        return XPathUtil.getNodeValue(node);
    }

    private static String getElementStringValue(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        do {
            switch (node2.getNodeType()) {
                case 1: 
                case 9: {
                    stringBuffer.append(Util.getElementStringValue(node2));
                    break;
                }
                default: {
                    stringBuffer.append(node2.getNodeValue());
                }
            }
        } while ((node2 = node2.getNextSibling()) != null);
        return stringBuffer.toString();
    }

    public static String getXSLStringValue(List list) {
        return list.isEmpty() ? "" : Util.getXSLStringValue((Node)list.get(0));
    }

    public static Locale parseLang(String string) throws IllegalArgumentException {
        if (string != null && string.length() > 0) {
            String string2 = "";
            String string3 = "";
            switch (string.length()) {
                default: {
                    if (string.charAt(5) != '-' || string.charAt(6) == '-') break;
                    int n = string.indexOf(45, 7);
                    string3 = n > 0 ? string.substring(6, n) : string.substring(6);
                }
                case 5: {
                    if (string.charAt(2) != '-' || string.charAt(3) == '-' || string.charAt(4) == '-') break;
                    string2 = string.substring(3, 5);
                }
                case 2: {
                    if (string.charAt(0) == '-' || string.charAt(1) == '-') break;
                    return new Locale(string.substring(0, 2), string2, string3);
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 6: 
            }
            throw new IllegalArgumentException();
        }
        return Locale.getDefault();
    }

    public static String unicodeEscape(char c) {
        String string = Integer.toHexString(c);
        return "\\u" + "0000".substring(string.length()) + string;
    }

    public static boolean stripWhitespaceNode(Node node) {
        ExpandedQName expandedQName;
        Node node2;
        short s = node.getNodeType();
        if (!(s != 3 && s != 4 || !XMLUtil.isXMLWhitespace(node.getNodeValue()) || (node2 = node.getParentNode()) == null || node2.getNodeType() != 1 || (expandedQName = DOMUtil.getExpandedName(node2)).localPartEquals("text") && expandedQName.namespaceNameEquals(Stylesheet.NAMESPACE))) {
            while (node2 != null) {
                Attr attr;
                if (node2.getNodeType() == 1 && (attr = ((Element)node2).getAttributeNode("xml:space")) != null) {
                    String string = attr.getNodeValue();
                    if (string.equals(SPACE_PRESERVE)) {
                        return false;
                    }
                    if (string.equals(SPACE_DEFAULT)) {
                        return true;
                    }
                }
                node2 = node2.getParentNode();
            }
            return true;
        }
        return false;
    }

    public static double getWildcardNamePriority(WildcardName wildcardName) {
        if (wildcardName.isFullWild()) {
            return -0.5;
        }
        if (wildcardName.isLocalWild()) {
            return -0.25;
        }
        return 0.0;
    }

    public static void indent(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("\t");
            ++n2;
        }
    }
}

