/*
 * Decompiled with CFR 0.152.
 */
import com.novell.java.io.DataAccessable;
import com.novell.java.io.NInputStream;
import com.novell.java.io.NOutputStream;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class DataViewFrame
extends JFrame
implements ActionListener {
    Context fileCtx;
    private static int emptySpace = 5;
    private static int buttonHeight = 25;
    private static int buttonWidth = 80;
    private static int mainPaneHeight = 300;
    private static int mainPaneWidth = 580;
    JButton asciiButton;
    JButton hexButton;
    JButton saveButton;
    JButton closeButton;
    JScrollPane fileScrollPane;
    JTextArea fileTextArea;
    JList fileHexList;
    DefaultListModel fileListModel;
    static final int hexDisplayByteCount = 16;
    private boolean textView;

    public DataViewFrame(String string, DirContext dirContext) {
        super(string);
        this.fileCtx = dirContext;
        this.getContentPane().setLayout(null);
        ((Component)this).setSize(mainPaneWidth + emptySpace * 2, mainPaneHeight + buttonHeight + emptySpace * 2);
        this.fileScrollPane = new JScrollPane();
        this.fileScrollPane.setBounds(emptySpace, emptySpace, mainPaneWidth - emptySpace * 2, mainPaneHeight - (buttonHeight + emptySpace * 3));
        this.getContentPane().add(this.fileScrollPane);
        this.asciiButton = new JButton("ASCII");
        this.asciiButton.setToolTipText("Display the data in ASCII form");
        this.asciiButton.setBounds(emptySpace, mainPaneHeight - (buttonHeight + emptySpace), buttonWidth, buttonHeight);
        this.asciiButton.addActionListener(this);
        this.getContentPane().add(this.asciiButton);
        this.hexButton = new JButton("Hex");
        this.hexButton.setToolTipText("Display the data in hexidecimal form");
        this.hexButton.setBounds(buttonWidth + emptySpace + emptySpace, mainPaneHeight - (buttonHeight + emptySpace), buttonWidth, buttonHeight);
        this.hexButton.addActionListener(this);
        this.getContentPane().add(this.hexButton);
        this.saveButton = new JButton("Save");
        this.saveButton.setToolTipText("Save the data");
        this.saveButton.setBounds((buttonWidth + emptySpace) * 2 + emptySpace, mainPaneHeight - (buttonHeight + emptySpace), buttonWidth, buttonHeight);
        this.saveButton.addActionListener(this);
        this.getContentPane().add(this.saveButton);
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.setBounds((buttonWidth + emptySpace) * 3 + emptySpace, mainPaneHeight - (buttonHeight + emptySpace), buttonWidth, buttonHeight);
        this.closeButton.addActionListener(this);
        this.getContentPane().add(this.closeButton);
        this.textView = false;
        this.showText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.asciiButton) {
            this.asciiButton_Action(actionEvent);
            return;
        }
        if (object == this.hexButton) {
            this.hexButton_Action(actionEvent);
            return;
        }
        if (object == this.saveButton) {
            this.saveButton_Action(actionEvent);
            return;
        }
        if (object == this.closeButton) {
            this.closeButton_Action(actionEvent);
        }
    }

    void asciiButton_Action(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.showText();
        ((Component)this).setVisible(true);
    }

    void hexButton_Action(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.showHex();
        ((Component)this).setVisible(true);
    }

    void saveButton_Action(ActionEvent actionEvent) {
        Cursor cursor = this.getCursor();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)new NOutputStream((DataAccessable)this.fileCtx));
            dataOutputStream.writeBytes(this.fileTextArea.getText());
            dataOutputStream.close();
        }
        catch (Throwable throwable) {}
        ((Component)this).setCursor(cursor);
    }

    void closeButton_Action(ActionEvent actionEvent) {
        this.dispose();
    }

    void showText() {
        if (this.textView) {
            return;
        }
        this.textView = true;
        if (this.fileHexList != null) {
            this.fileScrollPane.remove(this.fileHexList);
        }
        if (this.fileTextArea == null) {
            this.fileTextArea = new JTextArea();
            this.fileTextArea.setEditable(true);
            String string = System.getProperty("line.separator");
            String string2 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new NInputStream((DataAccessable)this.fileCtx)));
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    this.fileTextArea.append(String.valueOf(string2) + string);
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                this.fileTextArea.append(String.valueOf(string) + "<<< Interrupted >>>" + string);
                new MessageBox("Error", "Unable to read file:\n" + Util.getExceptionTrace((Throwable)iOException)).show();
            }
            catch (Throwable throwable) {
                new MessageBox("Error", "Unable to read file:\n" + Util.getExceptionTrace((Throwable)throwable)).show();
            }
        }
        this.fileScrollPane.getViewport().add(this.fileTextArea);
    }

    void showHex() {
        if (!this.textView) {
            return;
        }
        this.textView = false;
        if (this.fileTextArea != null) {
            this.fileScrollPane.getViewport().remove(this.fileTextArea);
        }
        if (this.fileHexList == null) {
            this.fileListModel = new DefaultListModel();
            this.fileHexList = new JList(this.fileListModel);
            this.fileHexList.setFont(new Font("Courier", 0, 12));
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new NInputStream((DataAccessable)this.fileCtx)));
                char[] cArray = new char[16];
                char[] cArray2 = new char[12 + cArray.length * 3 + 1 + cArray.length];
                char[] cArray3 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
                int n = 0;
                int n2 = 0;
                boolean bl = false;
                while (!bl) {
                    int n3 = 0;
                    int n4 = 8;
                    while (n4 > 0) {
                        cArray2[n3++] = cArray3[n2 >>> 4 * n4 & 0xF];
                        --n4;
                    }
                    cArray2[n3++] = 58;
                    cArray2[n3++] = 32;
                    n = bufferedReader.read(cArray, 0, cArray.length);
                    if (n < cArray.length) {
                        bl = true;
                    }
                    int n5 = 0;
                    while (n5 < cArray.length) {
                        if (n5 < n) {
                            cArray2[n3++] = cArray3[cArray[n5] >>> 4 & 0xF];
                            cArray2[n3++] = cArray3[cArray[n5] & 0xF];
                        } else {
                            cArray2[n3++] = 32;
                            cArray2[n3++] = 32;
                        }
                        if (n5 == cArray.length / 2 - 1) {
                            cArray2[n3++] = 32;
                            cArray2[n3++] = !bl ? 45 : 32;
                        }
                        cArray2[n3++] = 32;
                        ++n5;
                    }
                    cArray2[n3++] = 32;
                    int n6 = 0;
                    while (n6 < cArray.length) {
                        cArray2[n3++] = n6 < n ? (cArray[n6] < ' ' || cArray[n6] > '\u007f' ? 46 : cArray[n6]) : 32;
                        ++n6;
                    }
                    n2 += n;
                    this.fileListModel.addElement(new String(cArray2));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                this.fileListModel.addElement("<<< Interrupted >>>");
                new MessageBox("Error", "Unable to read file:\n" + Util.getExceptionTrace((Throwable)iOException)).show();
            }
            catch (Throwable throwable) {
                new MessageBox("Error", "Unable to read file:\n" + Util.getExceptionTrace((Throwable)throwable)).show();
            }
        }
        this.fileScrollPane.getViewport().add(this.fileHexList);
    }
}

