/*
 * Decompiled with CFR 0.152.
 */
import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.service.session.Session;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class NWAuthActionListener
implements ActionListener {
    ContextFrame frame;
    ContextTreeNode treeNode;
    Session session;
    JMenuItem loginMenuItem;
    JMenuItem logoutMenuItem;

    public NWAuthActionListener() {
    }

    public NWAuthActionListener(JFrame jFrame, ContextTreeNode contextTreeNode, Session session, JPopupMenu jPopupMenu) {
        this.frame = jFrame instanceof ContextFrame ? (ContextFrame)jFrame : null;
        this.treeNode = contextTreeNode;
        this.session = session;
        this.loginMenuItem = new JMenuItem("Login");
        this.loginMenuItem.setToolTipText("Login the session for this object");
        this.loginMenuItem.addActionListener(this);
        jPopupMenu.add(this.loginMenuItem);
        this.logoutMenuItem = new JMenuItem("Logout");
        this.logoutMenuItem.setToolTipText("Logout the session for this object");
        this.logoutMenuItem.addActionListener(this);
        jPopupMenu.add(this.logoutMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.loginMenuItem) {
            this.login_Action(actionEvent);
            return;
        }
        if (object == this.logoutMenuItem) {
            this.logout_Action(actionEvent);
        }
    }

    void login_Action(ActionEvent actionEvent) {
        try {
            Identity identity = this.session.createIdentity("");
            Authenticator.login((Identity)identity);
            if (this.frame != null) {
                this.frame.refreshMenuItem_Action(null);
                return;
            }
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to login this object:\n" + Util.getExceptionTrace((Throwable)exception)).show();
        }
    }

    void logout_Action(ActionEvent actionEvent) {
        try {
            Identity identity = this.session.createIdentity("");
            Authenticator.logout((Identity)identity);
            if (this.frame != null) {
                this.frame.refreshMenuItem_Action(null);
                return;
            }
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to logout this object:\n" + Util.getExceptionTrace((Throwable)exception)).show();
            exception.printStackTrace();
        }
    }
}

