/*
 * Decompiled with CFR 0.152.
 */
import com.novell.service.server.NWServer;
import com.novell.service.server.ServerVersions;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.naming.Context;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

class ServerMgmtFrame
extends JFrame
implements ActionListener {
    Context serverCtx;
    private static int emptySpace = 5;
    private static int buttonHeight = 25;
    private static int buttonWidth = 110;
    private static int mainPaneHeight = (buttonHeight + emptySpace) * 4;
    private static int mainPaneWidth = 400;
    private JLabel versionLabel;
    private JLabel nlmLabel;
    private JTextField nlmTextField;
    private JButton loadNLMButton;
    private JButton unloadNLMButton;
    private JButton closeButton;

    public ServerMgmtFrame() {
    }

    public ServerMgmtFrame(String string, DirContext dirContext) {
        super("Server Management: " + string);
        this.serverCtx = dirContext;
        this.getContentPane().setLayout(null);
        ((Component)this).setSize(mainPaneWidth, mainPaneHeight);
        try {
            Attributes attributes = dirContext.getAttributes("", new String[]{"ServerVersions"});
            ServerVersions serverVersions = (ServerVersions)attributes.get("ServerVersions").get();
            this.versionLabel = new JLabel("Server Version " + serverVersions.getMajorVersion() + "." + serverVersions.getMinorVersion() + " rev " + serverVersions.getRevision());
            this.versionLabel.setBorder(new EtchedBorder(1));
            this.versionLabel.setBounds(emptySpace, emptySpace, mainPaneWidth - emptySpace * 3, buttonHeight);
            this.versionLabel.setHorizontalAlignment(0);
            this.getContentPane().add(this.versionLabel);
        }
        catch (Exception exception) {
            new MessageBox("Error", "Unable to get attributes for object:\n" + Util.getExceptionTrace((Throwable)exception)).show();
        }
        this.nlmLabel = new JLabel("NLM command:");
        this.nlmLabel.setBounds(emptySpace, buttonHeight + emptySpace + emptySpace, buttonWidth, buttonHeight);
        this.getContentPane().add(this.nlmLabel);
        this.nlmTextField = new JTextField();
        this.nlmTextField.setBounds(buttonWidth + emptySpace + emptySpace, buttonHeight + emptySpace + emptySpace, mainPaneWidth - (buttonWidth + emptySpace * 3), buttonHeight);
        this.nlmTextField.setToolTipText("<vol:><path>NLMname<.ext> <parameters>");
        this.getContentPane().add(this.nlmTextField);
        this.loadNLMButton = new JButton("Load NLM");
        this.loadNLMButton.setToolTipText("Load the specified NLM");
        this.loadNLMButton.setBounds((mainPaneWidth - buttonWidth) / 2 - (buttonWidth + emptySpace), (buttonHeight + emptySpace) * 2 + emptySpace, buttonWidth, buttonHeight);
        this.loadNLMButton.addActionListener(this);
        this.getContentPane().add(this.loadNLMButton);
        this.unloadNLMButton = new JButton("Unload NLM");
        this.unloadNLMButton.setToolTipText("Unload the specified NLM");
        this.unloadNLMButton.setBounds((mainPaneWidth - buttonWidth) / 2, (buttonHeight + emptySpace) * 2 + emptySpace, buttonWidth, buttonHeight);
        this.unloadNLMButton.addActionListener(this);
        this.getContentPane().add(this.unloadNLMButton);
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText("Exit this window");
        this.closeButton.setBounds((mainPaneWidth - buttonWidth) / 2 + (buttonWidth + emptySpace), (buttonHeight + emptySpace) * 2 + emptySpace, buttonWidth, buttonHeight);
        this.closeButton.addActionListener(this);
        this.getContentPane().add(this.closeButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = this.nlmTextField.getText();
        if (object == this.loadNLMButton) {
            if (string != null && !string.equals("")) {
                ((NWServer)this.serverCtx).loadNLM(string);
                return;
            }
        } else if (object == this.unloadNLMButton) {
            if (string != null && !string.equals("")) {
                ((NWServer)this.serverCtx).unloadNLM(string);
                return;
            }
        } else if (object == this.closeButton) {
            ((Component)this).setVisible(false);
        }
    }
}

