/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.IOException;
import java.util.Arrays;

public class EnumResponse
extends SSResponse {
    private int idCount;
    private char[] secretIDs;

    public EnumResponse(byte[] value) {
        super("2.16.840.1.113719.1.148.100.14", value);
    }

    public int getCount() {
        return this.idCount;
    }

    public char[] getEnumeration() {
        char[] newbuf = new char[this.secretIDs.length];
        System.arraycopy(this.secretIDs, 0, newbuf, 0, this.secretIDs.length);
        return newbuf;
    }

    protected void finalize() throws Throwable {
        if (this.secretIDs != null) {
            Arrays.fill(this.secretIDs, ' ');
        }
        super.finalize();
    }

    protected void parsePacket() throws IOException {
        super.parsePacket();
        int size = this.asn1_seq.size();
        if (this.packetIdx < size) {
            ASN1Integer asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.idCount = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            ASN1OctetString asn1_string = (ASN1OctetString)this.asn1_seq.get(this.packetIdx++);
            this.secretIDs = SSResponse.formatString(asn1_string);
        }
    }
}

