/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.IOException;
import java.util.Arrays;

public class GetInfoResponse
extends SSResponse {
    private int enumBuffLen;
    private int hiddenCount;
    private transient char[] hint;
    private String lastAdminUnlockDN;
    private long lastAdminUnlockTime;
    private int lockCount;
    private int secretCount;
    private byte serverCryptoStrength;
    private int serverVersion;
    private int status;
    private String treeName;

    public GetInfoResponse(byte[] value) {
        super("2.16.840.1.113719.1.148.100.2", value);
    }

    public int getEnumBuffLen() {
        return this.enumBuffLen;
    }

    public char[] getHint() {
        char[] hintbuf = new char[this.hint.length];
        System.arraycopy(this.hint, 0, hintbuf, 0, this.hint.length);
        return hintbuf;
    }

    public String getLastAdminUnlockDN() {
        return this.lastAdminUnlockDN;
    }

    public long getLastAdminUnlockTime() {
        return this.lastAdminUnlockTime;
    }

    public int getNumHiddenSecrets() {
        return this.hiddenCount;
    }

    public int getNumLockedSecrets() {
        return this.lockCount;
    }

    public int getNumSecrets() {
        return this.secretCount;
    }

    public byte getServerCryptoStrength() {
        return this.serverCryptoStrength;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTreeName() {
        return this.treeName;
    }

    protected void finalize() throws Throwable {
        Arrays.fill(this.hint, '\u0000');
    }

    protected void parsePacket() throws IOException {
        ASN1OctetString asn1_string;
        ASN1Integer asn1_int;
        super.parsePacket();
        int size = this.asn1_seq.size();
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.serverVersion = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.lockCount = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.secretCount = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.status = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.enumBuffLen = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.serverCryptoStrength = (byte)asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_string = (ASN1OctetString)this.asn1_seq.get(this.packetIdx++);
            this.treeName = new String(SSResponse.formatString(asn1_string));
        }
        if (this.packetIdx < size) {
            asn1_string = (ASN1OctetString)this.asn1_seq.get(this.packetIdx++);
            if (this.hint != null) {
                Arrays.fill(this.hint, ' ');
            }
            this.hint = SSResponse.formatString(asn1_string);
        }
        if ((this.status & 0x4000000) == 0x4000000) {
            if (this.packetIdx < size) {
                asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
                this.lastAdminUnlockTime = asn1_int.intValue();
            }
            if (this.packetIdx < size) {
                asn1_string = (ASN1OctetString)this.asn1_seq.get(this.packetIdx++);
                this.lastAdminUnlockDN = new String(SSResponse.formatString(asn1_string));
            }
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.hiddenCount = asn1_int.intValue();
        }
    }
}

