/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.IOException;
import java.util.Arrays;

public class ReadResponse
extends SSResponse {
    private long accTime;
    private long crtTime;
    private long modTime;
    private transient byte[] secret;
    private int statFlags;

    public ReadResponse(byte[] value) {
        super("2.16.840.1.113719.1.148.100.4", value);
    }

    public long getAccessedTime() {
        return this.accTime;
    }

    public long getCreatedTime() {
        return this.crtTime;
    }

    public long getModifiedTime() {
        return this.modTime;
    }

    public byte[] getSecretValue() {
        byte[] secbuf = new byte[this.secret.length];
        System.arraycopy(this.secret, 0, secbuf, 0, this.secret.length);
        return secbuf;
    }

    public int getStatFlags() {
        return this.statFlags;
    }

    protected void finalize() throws Throwable {
        Arrays.fill(this.secret, (byte)0);
        super.finalize();
    }

    protected void parsePacket() throws IOException {
        ASN1Integer asn1_int;
        super.parsePacket();
        int size = this.asn1_seq.size();
        if (this.packetIdx < size) {
            ASN1Object obj;
            if ((obj = this.asn1_seq.get(this.packetIdx++)) instanceof ASN1OctetString) {
                ASN1OctetString asn1_string = (ASN1OctetString)obj;
                this.secret = asn1_string.byteValue();
            } else {
                this.secret = new byte[0];
            }
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.statFlags = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.crtTime = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.accTime = asn1_int.intValue();
        }
        if (this.packetIdx < size) {
            asn1_int = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.modTime = asn1_int.intValue();
        }
    }
}

