/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import java.io.Serializable;
import java.util.Arrays;

public abstract class SSExtension
implements Serializable {
    public static final String ENCODING = "UTF-8";
    protected transient byte[] packet;
    private String oid;

    public SSExtension(String oid) {
        this.oid = oid;
    }

    public SSExtension(String oid, byte[] value) {
        this(oid);
        this.packet = value;
    }

    public byte[] getEncodedValue() {
        if (this.packet != null) {
            byte[] packetbuf = new byte[this.packet.length];
            System.arraycopy(this.packet, 0, packetbuf, 0, this.packet.length);
            return packetbuf;
        }
        return null;
    }

    public String getID() {
        return this.oid;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SSExtension && this.oid.equals(((SSExtension)obj).oid)) {
            return Arrays.equals(this.packet, ((SSExtension)obj).packet);
        }
        return false;
    }

    public int hashCode() {
        return (this.oid + new String(this.packet)).hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " OID: " + this.oid;
    }

    protected void finalize() throws Throwable {
        if (this.packet != null) {
            Arrays.fill(this.packet, (byte)0);
        }
    }
}

