/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;
import sun.io.CharToByteConverter;

public class SetMasterPassRequest
extends SSRequest {
    private transient char[] mhint;
    private transient char[] mpass;

    public SetMasterPassRequest(int flags, String objName, char[] masterPass, char[] hint) {
        super("2.16.840.1.113719.1.148.100.17", flags, objName, false);
        this.mpass = masterPass;
        this.mhint = hint;
        this.constructPacket();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void constructPacket() throws SSException {
        char[] temphint;
        char[] temppass;
        ASN1OctetString asn1_hint;
        block11: {
            byte[] passbuf3222;
            super.constructPacket(false);
            ASN1OctetString asn1_pass = null;
            asn1_hint = null;
            temppass = null;
            temphint = null;
            try {
                try {
                    CharToByteConverter conv = CharToByteConverter.getConverter((String)"UTF-8");
                    temppass = new char[this.mpass.length + 1];
                    System.arraycopy(this.mpass, 0, temppass, 0, this.mpass.length);
                    temppass[this.mpass.length] = '\u0000';
                    temphint = new char[this.mhint.length + 1];
                    System.arraycopy(this.mhint, 0, temphint, 0, this.mhint.length);
                    temphint[this.mhint.length] = '\u0000';
                    byte[] passbuf2 = conv.convertAll(temppass);
                    byte[] hintbuf = conv.convertAll(temphint);
                    asn1_pass = new ASN1OctetString(passbuf2);
                    asn1_hint = new ASN1OctetString(hintbuf);
                    this.asn1_seq.add(asn1_pass);
                    this.asn1_seq.add(asn1_hint);
                    this.asn1_seq.encode(this.enc, this.out);
                    if (this.packet != null) {
                        Arrays.fill(this.packet, (byte)0);
                    }
                    this.packet = this.out.toByteArray();
                }
                catch (IOException e) {
                    throw new SSException(-849, (Throwable)e);
                }
                Object var9_9 = null;
                if (asn1_pass == null) break block11;
                passbuf3222 = asn1_pass.byteValue();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (asn1_pass != null) {
                    byte[] passbuf3222 = asn1_pass.byteValue();
                    Arrays.fill(passbuf3222, (byte)0);
                }
                if (temppass != null) {
                    Arrays.fill(temppass, '\u0000');
                }
                if (asn1_hint != null) {
                    byte[] hintbuf = asn1_hint.byteValue();
                    Arrays.fill(hintbuf, (byte)0);
                }
                if (temphint == null) throw throwable;
                Arrays.fill(temphint, '\u0000');
                throw throwable;
            }
            Arrays.fill(passbuf3222, (byte)0);
        }
        if (temppass != null) {
            Arrays.fill(temppass, '\u0000');
        }
        if (asn1_hint != null) {
            byte[] hintbuf = asn1_hint.byteValue();
            Arrays.fill(hintbuf, (byte)0);
        }
        if (temphint == null) return;
        Arrays.fill(temphint, '\u0000');
    }
}

