/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.jndi;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.ldap.ber.EnumRequest;
import com.novell.security.sso.ldap.ber.EnumResponse;
import com.novell.security.sso.ldap.ber.GetInfoResponse;
import com.novell.security.sso.ldap.ber.SSRequest;
import com.novell.security.sso.ldap.ber.SSResponse;
import com.novell.security.sso.ldap.ber.SetMasterPassRequest;
import com.novell.security.sso.ldap.ber.UnlockRequest;
import com.novell.security.sso.ldap.jndi.JNDISecret;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;

public final class JNDISecretStore
extends SecretStore {
    private transient LdapContext ctx;

    public JNDISecretStore(Hashtable environment) throws IllegalArgumentException, SSException {
        block13: {
            if (System.getProperty("javax.net.debug") != null) {
                throw new SecurityException("javax.net.debug is turned on. Access to JNDISecretStore denied. Necessary to turn debugging off!");
            }
            try {
                if (environment.containsKey("com.novell.sso.handle")) {
                    Object context = environment.get("com.novell.sso.handle");
                    if (context instanceof LdapContext) {
                        this.env = (Hashtable)environment.clone();
                        this.ctx = (LdapContext)context;
                        if (!this.env.containsKey("com.novell.sso.targetdn") || this.env.get("com.novell.sso.targetdn").toString().length() == 0) {
                            try {
                                String tempStr = this.ctx.getNameInNamespace();
                                if (tempStr != null && tempStr.length() > 0) {
                                    this.env.put("com.novell.sso.targetdn", tempStr);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!this.env.containsKey("com.novell.sso.targetdn") && this.ctx.getEnvironment().containsKey("java.naming.security.principal") && this.ctx.getEnvironment().get("java.naming.security.principal").toString().length() > 0) {
                            this.env.put("com.novell.sso.targetdn", this.ctx.getEnvironment().get("java.naming.security.principal"));
                        }
                        if (this.ctx.getEnvironment().contains("java.naming.security.principal")) {
                            this.env.put("com.novell.sso.callerdn", this.ctx.getEnvironment().get("java.naming.security.principal"));
                        }
                        if (this.ctx.getEnvironment().contains("java.naming.provider.url")) {
                            this.env.put("com.novell.sso.serverdn", this.ctx.getEnvironment().get("java.naming.provider.url"));
                        }
                        if (!this.env.containsKey("com.novell.sso.targetdn") || this.env.get("com.novell.sso.targetdn").toString().length() <= 0) {
                            throw new IllegalArgumentException("not possible to obtain \"com.novell.sso.userdn\" from \"com.novell.sso.handle\" or environment");
                        }
                        break block13;
                    }
                    throw new IllegalArgumentException("\"com.novell.sso.context\" is not a LdapContext object");
                }
                throw new IllegalArgumentException("\"com.novell.sso.context\" not specified");
            }
            catch (NamingException e) {
                throw new SSException(e);
            }
        }
    }

    public synchronized Secret getSecret0(String id, boolean useMasterPassword) {
        if (useMasterPassword) {
            return new JNDISecret(id, this, this.ctx, (String)this.env.get("com.novell.sso.targetdn"), this.masterPassword);
        }
        return new JNDISecret(id, this, this.ctx, (String)this.env.get("com.novell.sso.targetdn"));
    }

    protected final synchronized void getServiceInfo0(int flags) throws SSException {
        try {
            this.initialized = true;
            SSRequest internal = new SSRequest("2.16.840.1.113719.1.148.100.1", flags, (String)this.env.get("com.novell.sso.targetdn"));
            InternalRequest req = new InternalRequest(internal.getID(), internal.getEncodedValue());
            InternalResponse tempResp = (InternalResponse)this.ctx.extendedOperation(req);
            GetInfoResponse resp = new GetInfoResponse(tempResp.getEncodedValue());
            if (resp.getErrorCode() != 0) {
                throw new SSException(resp.getErrorCode());
            }
            this.serverVersion = resp.getServerVersion();
            this.clientVersion = 772;
            this.lockCount = resp.getNumLockedSecrets();
            this.secretCount = resp.getNumSecrets();
            this.status = resp.getStatus();
            this.enumBuffLen = resp.getEnumBuffLen();
            this.clientCryptoStrength = 0;
            this.serverCryptoStrength = resp.getServerCryptoStrength();
            this.lastAdminUnlockDn = resp.getLastAdminUnlockDN();
            this.lastAdminUnlockTime = resp.getLastAdminUnlockTime();
            this.env.put("com.novell.sso.tree", resp.getTreeName());
            Arrays.fill(this.hint, ' ');
            this.hint = resp.getHint();
        }
        catch (NamingException e) {
            throw new SSException(JNDISecretStore.checkException(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void commitMasterPasswordChange0(int flags, char[] passhint) throws SSException {
        if (this.masterPassword.length() <= 0) {
            throw new IllegalArgumentException("Master Password length is zero");
        }
        char[] newBuf = new char[this.masterPassword.length()];
        if (newBuf.length > 0) {
            this.masterPassword.getChars(0, newBuf.length, newBuf, 0);
        }
        try {
            try {
                SetMasterPassRequest internal = new SetMasterPassRequest(flags, (String)this.env.get("com.novell.sso.targetdn"), newBuf, passhint);
                InternalRequest req = new InternalRequest(internal.getID(), internal.getEncodedValue());
                InternalResponse tempResp = (InternalResponse)this.ctx.extendedOperation(req);
                SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
                if (resp.getErrorCode() != 0) {
                    throw new SSException(resp.getErrorCode());
                }
                Arrays.fill(this.hint, ' ');
                char[] cArray = passhint;
                synchronized (cArray) {
                    char[] hintbuf = new char[passhint.length];
                    System.arraycopy(passhint, 0, hintbuf, 0, passhint.length);
                    this.hint = hintbuf;
                }
            }
            catch (NullPointerException e) {
                Arrays.fill(this.hint, ' ');
                char[] req = passhint;
                synchronized (req) {
                    char[] hintbuf = new char[passhint.length];
                    System.arraycopy(passhint, 0, hintbuf, 0, passhint.length);
                    this.hint = hintbuf;
                }
                Object var13_15 = null;
                Arrays.fill(newBuf, ' ');
                return;
            }
            catch (NamingException e) {
                throw new SSException(JNDISecretStore.checkException(e));
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            Arrays.fill(newBuf, ' ');
            throw throwable;
        }
        Arrays.fill(newBuf, ' ');
    }

    protected final synchronized StringTokenizer enumerateSecrets0(int flags, String filter, int maxLen) throws SSException {
        try {
            EnumRequest internal = new EnumRequest(flags, (String)this.env.get("com.novell.sso.targetdn"), filter, maxLen);
            InternalRequest req = new InternalRequest(internal.getID(), internal.getEncodedValue());
            InternalResponse tempResp = (InternalResponse)this.ctx.extendedOperation(req);
            EnumResponse resp = new EnumResponse(tempResp.getEncodedValue());
            if (resp.getErrorCode() != 0) {
                throw new SSException(resp.getErrorCode());
            }
            return new StringTokenizer(new String(resp.getEnumeration()), "*");
        }
        catch (NamingException e) {
            throw new SSException(JNDISecretStore.checkException(e));
        }
    }

    protected final synchronized void removeSecretStore0(int flags) throws SSException {
        try {
            SSRequest internal = new SSRequest("2.16.840.1.113719.1.148.100.11", flags, (String)this.env.get("com.novell.sso.targetdn"));
            InternalRequest req = new InternalRequest(internal.getID(), internal.getEncodedValue());
            InternalResponse tempResp = (InternalResponse)this.ctx.extendedOperation(req);
            SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
            if (resp.getErrorCode() != 0) {
                throw new SSException(resp.getErrorCode());
            }
        }
        catch (NullPointerException e) {
        }
        catch (NamingException e) {
            throw new SSException(JNDISecretStore.checkException(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void unlockSecretStore0(int flags) throws SSException {
        char[] newBuf = null;
        if ((flags & 4) != 4) {
            if (this.masterPassword == null) {
                throw new IllegalArgumentException("master password is null");
            }
            flags |= 0x20;
            newBuf = new char[this.masterPassword.length()];
            if (newBuf.length > 0) {
                this.masterPassword.getChars(0, newBuf.length, newBuf, 0);
            }
        }
        try {
            try {
                UnlockRequest internal = new UnlockRequest(flags, (String)this.env.get("com.novell.sso.targetdn"), newBuf);
                InternalRequest req = new InternalRequest(internal.getID(), internal.getEncodedValue());
                InternalResponse tempResp = (InternalResponse)this.ctx.extendedOperation(req);
                SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
                if (resp.getErrorCode() != 0) {
                    throw new SSException(resp.getErrorCode());
                }
                Object var8_9 = null;
            }
            catch (NullPointerException e) {
                Object var8_10 = null;
                Arrays.fill(newBuf, ' ');
                return;
            }
            catch (NamingException e) {
                throw new SSException(JNDISecretStore.checkException(e));
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            Arrays.fill(newBuf, ' ');
            throw throwable;
        }
        Arrays.fill(newBuf, ' ');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void unlockSecretStore0(int flags, char[] ndsPassword) throws SSException {
        char[] newBuf;
        if ((flags & 4) != 4) {
            if (ndsPassword == null) {
                throw new IllegalArgumentException("NDS Password is null");
            }
        } else if (ndsPassword == null) {
            ndsPassword = new char[]{};
        }
        char[] cArray = ndsPassword;
        synchronized (cArray) {
            newBuf = new char[ndsPassword.length];
            System.arraycopy(ndsPassword, 0, newBuf, 0, ndsPassword.length);
        }
        try {
            try {
                UnlockRequest internal = new UnlockRequest(flags, (String)this.env.get("com.novell.sso.targetdn"), newBuf);
                InternalRequest req = new InternalRequest(internal.getID(), internal.getEncodedValue());
                InternalResponse tempResp = (InternalResponse)this.ctx.extendedOperation(req);
                SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
                if (resp.getErrorCode() != 0) {
                    throw new SSException(resp.getErrorCode());
                }
                Object var10_11 = null;
            }
            catch (NullPointerException e) {
                Object var10_12 = null;
                Arrays.fill(newBuf, '\u0000');
                return;
            }
            catch (NamingException e) {
                throw new SSException(JNDISecretStore.checkException(e));
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            Arrays.fill(newBuf, '\u0000');
            throw throwable;
        }
        Arrays.fill(newBuf, '\u0000');
    }

    static int checkException(NamingException e) throws SSException {
        try {
            String str = e.getMessage();
            int offset = str.indexOf("8");
            if (offset != -1) {
                ++offset;
                String error = str.substring(offset = str.indexOf("-8", offset), offset + 4);
                int err = Integer.parseInt(error);
                if (err >= -800 && err <= -899) {
                    return err;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SSException(e);
    }

    static class InternalResponse
    implements ExtendedResponse {
        private String id;
        private byte[] value;

        public InternalResponse(String identifier, byte[] requestValue) {
            this.id = identifier;
            this.value = requestValue;
        }

        public byte[] getEncodedValue() {
            return this.value;
        }

        public String getID() {
            return this.id;
        }
    }

    static class InternalRequest
    implements ExtendedRequest {
        private String id;
        private byte[] value;

        public InternalRequest(String identifier, byte[] requestValue) {
            this.id = identifier;
            this.value = requestValue;
        }

        public byte[] getEncodedValue() {
            return this.value;
        }

        public String getID() {
            return this.id;
        }

        public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
            return new InternalResponse(id, berValue);
        }
    }
}

