/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.CommonImpl;
import com.novell.idm.driver.ComposerPublicationShim;
import com.novell.idm.driver.ComposerServiceHelper;
import com.novell.idm.driver.ComposerSubscriptionShim;
import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RequiredConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.HashMap;

public class ComposerDriverShim
extends CommonImpl
implements DriverShim {
    private static final String DEFAULT_PASSWORD = null;
    ComposerServiceHelper mComposerService;
    ComposerSubscriptionShim mSubscriptionShim;
    ComposerPublicationShim mPublicationShim;
    String driverCachePath;

    public ComposerDriverShim() {
        super("ComposerDriverShim");
        this.setDriverRDN("ComposerDriverShim");
        this.setTrace(null);
        this.setDriverParams();
    }

    private void setDriverParams() {
        this.driverParams = new HashMap(8);
        Parameter param = new Parameter("ComposerContext", null, DataType.STRING);
        param.add((Constraint)RequiredConstraint.REQUIRED);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServiceDriverInitMethodName", "Initialize", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServiceDriverGetSchemaMethodName", "GetSchema", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServiceDriverShutdownMethodName", "Shutdown", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerDriverCachePath", ".", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerDriverCachePolicyMax", "100", DataType.INT);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServicePublisherInitMethodName", "InitializePublisher", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServicePublisherGetEventsMethodName", "GetEvents", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServiceSubscriberInitMethodName", "InitializeSubscriber", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
        param = new Parameter("ComposerServiceSubscriberExecuteMethodName", "Execute", DataType.STRING);
        this.driverParams.put(param.tagName(), param);
    }

    public XmlDocument init(XmlDocument initXML) {
        String driverInitMethod;
        String mComposerContext;
        XDSResultDocument result = new XDSResultDocument();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            this.trace.trace("Init: DriverDn = " + init.srcDN());
            this.setDriverDN(init.srcDN());
            this.trace.trace("Init: getDriverDn = " + this.getDriverDN());
            init.parameters(this.driverParams);
            mComposerContext = this.driverParams.get("ComposerContext").toString();
            driverInitMethod = this.driverParams.get("ComposerServiceDriverInitMethodName").toString();
            this.driverCachePath = this.driverParams.get("ComposerDriverCachePath").toString();
            this.trace.trace("Init: ComposerServiceContext = " + mComposerContext, 3);
            this.trace.trace("Init: ComposerServiceDriverInitMethodName = " + driverInitMethod, 3);
            this.trace.trace("Init: ComposerServiceDriverGetSchemaMethodName = " + this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServiceDriverShutdownMethodName = " + this.driverParams.get("ComposerServiceDriverShutdownMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServicePublisherInitMethodName = " + this.driverParams.get("ComposerServicePublisherInitMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServicePublisherGetEventsMethodName = " + this.driverParams.get("ComposerServicePublisherGetEventsMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServiceSubsriberInitMethodName = " + this.driverParams.get("ComposerServiceSubscriberInitMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServiceSubsriberExecuteMethodName = " + this.driverParams.get("ComposerServiceSubscriberExecuteMethodName").toString(), 3);
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
            return result.toXML();
        }
        this.mComposerService = new ComposerServiceHelper(mComposerContext);
        this.mSubscriptionShim = new ComposerSubscriptionShim(this, this.mComposerService);
        this.mPublicationShim = new ComposerPublicationShim(this, this.mComposerService);
        this.trace.trace("init() calling Composer WebService: " + driverInitMethod, 3);
        return this.mComposerService.callComposerService(initXML, driverInitMethod);
    }

    public XmlDocument shutdown(XmlDocument aReason) {
        this.mPublicationShim.stop();
        String driverGetSchemaMethod = this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString();
        this.trace.trace("getSchema calling Composer WebService: " + driverGetSchemaMethod, 3);
        String driverShutdownMethod = this.driverParams.get("ComposerServiceDriverShutdownMethodName").toString();
        this.trace.trace("shutdown() calling Composer WebService: " + driverShutdownMethod, 3);
        return this.mComposerService.callComposerService(aReason, driverShutdownMethod);
    }

    public SubscriptionShim getSubscriptionShim() {
        return this.mSubscriptionShim;
    }

    public XmlDocument getSchema(XmlDocument initXML) {
        String mComposerContext;
        XDSResultDocument result = new XDSResultDocument();
        try {
            XDSInitDocument init = new XDSInitDocument(initXML);
            init.parameters(this.driverParams);
            mComposerContext = this.driverParams.get("ComposerContext").toString();
        }
        catch (Exception e) {
            StatusAttributes attrs = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)result, (StatusAttributes)attrs, null, (Exception)e, (boolean)XDSUtil.appendStackTrace((Exception)e), (XmlDocument)initXML);
            return result.toXML();
        }
        this.mComposerService = new ComposerServiceHelper(mComposerContext);
        String driverGetSchemaMethod = this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString();
        this.trace.trace("getSchema() calling Composer WebService: " + driverGetSchemaMethod, 3);
        return this.mComposerService.callComposerService(initXML, this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString());
    }

    public PublicationShim getPublicationShim() {
        return this.mPublicationShim;
    }

    public String getDriverCachePath() {
        return this.driverCachePath;
    }
}

