/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.CommonImpl;
import com.novell.idm.driver.ComposerDriverShim;
import com.novell.idm.driver.ComposerServiceHelper;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;

public class ComposerSubscriptionShim
extends CommonImpl
implements SubscriptionShim {
    private static final String TRACE_SUFFIX = "SubscriberShim";
    private ComposerDriverShim driver;
    ComposerServiceHelper composerService = null;

    ComposerSubscriptionShim(ComposerDriverShim driver, ComposerServiceHelper composerService) {
        super("ComposerSubscriptionShim");
        this.composerService = composerService;
        this.driver = driver;
        this.setDriverRDN(driver.getDriverRDN());
        this.setTrace(TRACE_SUFFIX);
        this.setDriverParams(driver.getDriverParams());
    }

    public XmlDocument init(XmlDocument aInitParameters) {
        return this.composerService.callComposerService(aInitParameters, this.driverParams.get("ComposerServiceSubscriberInitMethodName").toString());
    }

    public XmlDocument execute(XmlDocument aXmldoc, XmlQueryProcessor aQuery) {
        String subscriberExecuteMethod = this.driverParams.get("ComposerServiceSubscriberExecuteMethodName").toString();
        this.trace.trace(aXmldoc);
        this.trace.trace("execute() calling Composer WebService: " + subscriberExecuteMethod, 3);
        return this.composerService.callComposerService(aXmldoc, subscriberExecuteMethod);
    }
}

