/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

abstract class GUIDTranslator {
    static final int LENGTH_GUID = 36;
    private static final char[] binToAscii = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] asciiToBinLo = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
    private static final int[] asciiToBinHi = new int[]{0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 0, 0, 0, 0, 0, 0, 0, 160, 176, 192, 208, 224, 240};

    GUIDTranslator() {
    }

    public static boolean isValid(String guid) {
        if (guid == null || guid.length() < 36) {
            return false;
        }
        char[] chars = guid.toCharArray();
        return chars[8] == '-' && chars[13] == '-' && chars[18] == '-' && chars[23] == '-' && GUIDTranslator.isValidHex(chars, 0, 8) && GUIDTranslator.isValidHex(chars, 9, 13) && GUIDTranslator.isValidHex(chars, 14, 18) && GUIDTranslator.isValidHex(chars, 24, 36);
    }

    private static boolean isValidHex(char[] hex, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = hex[i];
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F') continue;
            return false;
        }
        return true;
    }

    public static String binGuidToString(byte[] guid) {
        GUIDTranslator.byteSwap(0, 3, guid);
        GUIDTranslator.byteSwap(4, 5, guid);
        GUIDTranslator.byteSwap(6, 7, guid);
        String hexString = GUIDTranslator.encodeAsciiHex(guid);
        StringBuffer buffer = new StringBuffer();
        buffer.append(hexString.substring(0, 8));
        buffer.append('-');
        buffer.append(hexString.substring(8, 12));
        buffer.append('-');
        buffer.append(hexString.substring(12, 16));
        buffer.append('-');
        buffer.append(hexString.substring(16, 20));
        buffer.append('-');
        buffer.append(hexString.substring(20));
        return buffer.toString();
    }

    static byte[] stringGuidtoBin(String guid) {
        StringBuffer buffer = new StringBuffer(guid.length() - 4);
        for (int c = 0; c < guid.length(); ++c) {
            char chr = guid.charAt(c);
            if (chr == '-') continue;
            buffer.append(chr);
        }
        byte[] bytes = GUIDTranslator.decodeAsciiHex(buffer.toString());
        GUIDTranslator.byteSwap(0, 3, bytes);
        GUIDTranslator.byteSwap(4, 5, bytes);
        GUIDTranslator.byteSwap(6, 7, bytes);
        return bytes;
    }

    static byte[] decodeAsciiHex(String hex) {
        int len = hex.length();
        byte[] bytes = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            bytes[j++] = (byte)(asciiToBinHi[hex.charAt(i) - 48] + asciiToBinLo[hex.charAt(i + 1) - 48]);
        }
        return bytes;
    }

    private static String encodeAsciiHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            byte temp = data[i];
            sb.append(binToAscii[temp >> 4 & 0xF]);
            sb.append(binToAscii[temp & 0xF]);
        }
        return sb.toString();
    }

    private static void byteSwap(int begin, int end, byte[] bytes) {
        for (int i = begin; i < begin + (end + 1 - begin) / 2; ++i) {
            byte b = bytes[i];
            int j = end - (i - begin);
            bytes[i] = bytes[j];
            bytes[j] = b;
        }
    }
}

