/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.xml.dom.DOMQuery;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.xpath.NodeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InputDocumentAtomizer {
    private Document srcDoc;
    private int currentInputChildIndex;

    public InputDocumentAtomizer(Document document) {
        this.srcDoc = document;
        this.currentInputChildIndex = 0;
    }

    public Node getNdsNode() {
        Element targetNdsElement = null;
        targetNdsElement = this.srcDoc.getDocumentElement();
        if (!targetNdsElement.getNodeName().equals("nds")) {
            targetNdsElement = null;
        }
        return targetNdsElement;
    }

    public Node getSourceNode() {
        Node targetSourceElement = null;
        DOMQuery query = new DOMQuery("nds/source");
        try {
            NodeSet nList = query.evaluate((Node)this.srcDoc);
            if (!nList.isEmpty()) {
                targetSourceElement = nList.first();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return targetSourceElement;
    }

    public Node getInputNode() {
        Node inputElement = null;
        DOMQuery query = new DOMQuery("nds/input");
        try {
            NodeSet nList = query.evaluate((Node)this.srcDoc);
            if (!nList.isEmpty()) {
                inputElement = nList.first();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputElement;
    }

    public Node readInputChildNode() {
        NodeList inputKids;
        Node inputOp = null;
        Node inputNode = this.getInputNode();
        if (inputNode != null && (inputKids = inputNode.getChildNodes()).getLength() > 0) {
            while (this.currentInputChildIndex < inputKids.getLength() && (inputOp = inputKids.item(this.currentInputChildIndex)).getNodeType() != 1) {
                ++this.currentInputChildIndex;
            }
            inputOp = inputKids.item(this.currentInputChildIndex++);
        }
        return inputOp;
    }

    public Document constructSingleInputElementDocument() throws DOMException {
        Document target = DocumentFactory.newDocument();
        Node ndsNode = this.getNdsNode();
        if (ndsNode != null) {
            Node targetNdsNode = target.appendChild(target.importNode(ndsNode, false));
            Node sourceNode = this.getSourceNode();
            if (sourceNode != null) {
                targetNdsNode.appendChild(target.importNode(sourceNode, true));
            }
            Node targetInputChildren = null;
            Node inputNode = this.getInputNode();
            if (inputNode != null) {
                Node targetInputNode = targetNdsNode.appendChild(target.importNode(this.getInputNode(), false));
                Node inputOperation = null;
                inputOperation = this.readInputChildNode();
                if (inputOperation != null) {
                    targetInputChildren = targetInputNode.appendChild(target.importNode(inputOperation, true));
                }
            }
            if (inputNode == null || targetInputChildren == null) {
                target = null;
            }
        }
        return target;
    }
}

