/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.DOMUtil;
import com.novell.idm.driver.GUIDTranslator;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.xml.util.Base64Codec;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JDBMFileManager {
    private static final String SEPARATOR = "_";
    private static final int LENGTH_BUFFER = 1024;
    private static final int LENGTH_MAX_FILE_NAME = 256;
    private static final int LENGTH_EXTENSION = 3;
    public static final String EXTENSION_DATABASE;
    public static final String EXTENSION_LOG;
    private static final String[] EXTENSIONS;
    private static final int NUM_EXTENSIONS;
    private static final String[] CURRENT_DIRS;
    private String _dn;
    private String _prefix;
    private String _path;
    private QueryProcessor _processor;
    private String _fileName;
    private List _guids;
    private String _guid;
    private Map _orphanedFiles;
    private StringBuffer _buffer;
    private boolean _forwardSlash;
    private boolean _filesPresent;

    private static boolean isJDBMExtension(String ext) {
        for (int e = 0; e < EXTENSIONS.length; ++e) {
            if (!EXTENSIONS[e].equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCurrentDir(String dir) {
        for (int d = 0; d < CURRENT_DIRS.length; ++d) {
            if (!CURRENT_DIRS[d].equals(dir)) continue;
            return true;
        }
        return false;
    }

    public JDBMFileManager(String driverDN, String directoryPath, String filePrefix, QueryProcessor processor) throws FileManagerException {
        this.setDN(driverDN);
        this.setPath(directoryPath);
        this.setPrefix(filePrefix);
        this.setProcessor(processor);
        this._guids = new ArrayList();
        this._orphanedFiles = new HashMap();
        this._buffer = new StringBuffer(LENGTH_BUFFER);
        this.setGUIDs();
        this.queryForGUIDs();
        this.deleteOrphanedFiles();
        System.out.println("JDBMFileManager Calling generateUniqueFileName");
        this.generateUniqueFileName();
        System.out.println("JDBMFileManager FileName = " + this._fileName);
    }

    private void setDN(String dn) {
        if (DOMUtil.noValue(dn)) {
            throw new IllegalArgumentException("Object DN is null or empty string.");
        }
        this._dn = dn;
    }

    private void setPath(String path) {
        if (DOMUtil.noValue(path)) {
            throw new IllegalArgumentException("Directory path is null or empty string.");
        }
        this._path = path;
        if (this._path.indexOf(47) != -1) {
            this._forwardSlash = true;
        }
    }

    private void setPrefix(String prefix) {
        if (DOMUtil.noValue(prefix)) {
            throw new IllegalArgumentException("File name prefix is null or empty string.");
        }
        if (prefix.length() + SEPARATOR.length() + 36 + LENGTH_EXTENSION > LENGTH_MAX_FILE_NAME) {
            throw new IllegalArgumentException("File name prefix is too long.");
        }
        this._prefix = prefix;
    }

    private void setProcessor(QueryProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("QueryProcessor instance is null.");
        }
        this._processor = processor;
    }

    public String getUniqueFileName() {
        return this._fileName;
    }

    public boolean filesAlreadyPresent() {
        return this._filesPresent;
    }

    private void generateUniqueFileName() {
        this._buffer.delete(0, this._buffer.length());
        this._buffer.append(this._path);
        char c = this._path.charAt(this._path.length() - 1);
        if (c != '/' && c != '\\') {
            if (this._forwardSlash) {
                this._buffer.append('/');
            } else {
                this._buffer.append('\\');
            }
        }
        this._buffer.append(this._prefix);
        this._buffer.append(SEPARATOR);
        this._buffer.append(this._guid);
        this._fileName = this._buffer.toString().toLowerCase();
        this._buffer = null;
    }

    public String getGUID() {
        return this._guid;
    }

    private void setGUIDs() throws FileManagerException {
        File[] files;
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int desiredLength = JDBMFileManager.this._prefix.length() + SEPARATOR.length() + 36 + LENGTH_EXTENSION;
                int dotIndex = name.length() - LENGTH_EXTENSION;
                return name.length() == desiredLength && JDBMFileManager.this._prefix.equalsIgnoreCase(name.substring(0, JDBMFileManager.this._prefix.length())) && JDBMFileManager.isJDBMExtension(name.substring(dotIndex, name.length()));
            }
        };
        File file = new File(this._path);
        if (!JDBMFileManager.isCurrentDir(this._path)) {
            if (!file.mkdirs()) {
                throw new FileManagerException("Unable to create directories '" + this._path + "'.");
            }
            if (!file.isDirectory()) {
                file.delete();
                throw new FileManagerException("Path '" + this._path + "' is not a directory.");
            }
        }
        if ((files = file.listFiles(filter)) == null) {
            throw new FileManagerException("Path '" + this._path + "' is not a directory, does not exist, or is not accessible.");
        }
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            String name = file.getName();
            String id = name.substring(this._prefix.length() + SEPARATOR.length(), name.length() - LENGTH_EXTENSION);
            if (GUIDTranslator.isValid(id = id.toUpperCase())) {
                ArrayList<File> list;
                if (!this._guids.contains(id)) {
                    this._guids.add(id);
                }
                if ((list = (ArrayList<File>)this._orphanedFiles.get(id)) == null) {
                    list = new ArrayList<File>(NUM_EXTENSIONS);
                    this._orphanedFiles.put(id, list);
                }
                list.add(file);
                continue;
            }
            this.delete(file);
        }
    }

    private boolean delete(File file) {
        try {
            return file.delete();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public boolean deleteFiles() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(JDBMFileManager.this._fileName);
            }
        };
        File[] files = new File(this._path).listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            if (this.delete(files[i])) continue;
            return false;
        }
        return true;
    }

    private void queryForGUIDs() throws FileManagerException {
        this._buffer.delete(0, this._buffer.length());
        this._buffer.append("<nds>");
        this._buffer.append("<input>");
        this._buffer.append("<query scope=\"entry\" ");
        this._buffer.append("dest-dn=\"" + this._dn + "\">");
        this._buffer.append("<read-attr attr-name=\"GUID\"/>");
        this._buffer.append("</query>");
        ListIterator l = this._guids.listIterator();
        while (l.hasNext()) {
            char[] guid = Base64Codec.encode((byte[])GUIDTranslator.stringGuidtoBin((String)l.next()));
            this._buffer.append("<query>");
            this._buffer.append("<search-attr attr-name=\"GUID\">");
            this._buffer.append("<value type=\"octet\">");
            this._buffer.append(guid);
            this._buffer.append("</value>");
            this._buffer.append("</search-attr>");
            this._buffer.append("<read-attr attr-name=\"GUID\"/>");
            this._buffer.append("</query>");
        }
        this._buffer.append("</input>");
        this._buffer.append("</nds>");
        XmlDocument guidsQuery = new XmlDocument(this._buffer.toString());
        Document od = this._processor.query(guidsQuery).getDocument();
        this.getGUIDValues(od.getElementsByTagName("value"));
    }

    private void getGUIDValues(NodeList nodes) throws FileManagerException {
        if (nodes.getLength() < 1) {
            throw new ObjectNotFoundException("Object '" + this._dn + "' does not exist.");
        }
        Element element = (Element)nodes.item(0);
        String guid = DOMUtil.getChildText(element);
        if (guid == null) {
            throw new InfoUnavailableException("Unable to read GUID for object '" + this._dn + "'.");
        }
        byte[] bytes = this.decode(guid);
        if (bytes == null) {
            throw new InfoUnavailableException("Unable to read GUID for object '" + this._dn + "'.");
        }
        this._guid = GUIDTranslator.binGuidToString(bytes);
        for (int i = 1; i < nodes.getLength(); ++i) {
            element = (Element)nodes.item(i);
            guid = DOMUtil.getChildText(element);
            if (guid == null || (bytes = this.decode(guid)) == null) continue;
            guid = GUIDTranslator.binGuidToString(bytes);
            if (!this._filesPresent && guid.compareTo(this._guid) == 0) {
                this._filesPresent = true;
            }
            this._orphanedFiles.remove(guid);
        }
    }

    private byte[] decode(String encoded) throws InfoCorruptException {
        try {
            return Base64Codec.decode((String)encoded);
        }
        catch (IOException io) {
            InfoCorruptException ice = new InfoCorruptException("Unable to decode GUID '" + encoded + "'.");
            ice.setException(io);
            throw ice;
        }
    }

    private void deleteOrphanedFiles() {
        Iterator i = this._orphanedFiles.values().iterator();
        while (i.hasNext()) {
            ListIterator l = ((List)i.next()).listIterator();
            while (l.hasNext()) {
                this.delete((File)l.next());
            }
        }
    }

    static {
        NUM_EXTENSIONS = 2;
        EXTENSION_DATABASE = ".db";
        EXTENSION_LOG = ".lg";
        EXTENSIONS = new String[NUM_EXTENSIONS];
        JDBMFileManager.EXTENSIONS[0] = EXTENSION_DATABASE;
        JDBMFileManager.EXTENSIONS[1] = EXTENSION_LOG;
        CURRENT_DIRS = new String[]{".", "." + File.pathSeparator};
    }

    public static class QueryProcessor {
        private XmlCommandProcessor _command;
        private XmlQueryProcessor _query;

        public QueryProcessor(XmlCommandProcessor command, XmlQueryProcessor query) {
            if (command == null) {
                throw new IllegalArgumentException("Command processor is null.");
            }
            if (query == null) {
                throw new IllegalArgumentException("Query processor is null.");
            }
            this._command = command;
            this._query = query;
        }

        public QueryProcessor(XmlQueryProcessor query) {
            if (query == null) {
                throw new IllegalArgumentException("Query processor is null.");
            }
            this._query = query;
        }

        XmlDocument query(XmlDocument xml) {
            if (this._command == null) {
                return this._query.query(xml);
            }
            return this._command.execute(xml, this._query);
        }
    }

    static class InfoCorruptException
    extends FileManagerException {
        public InfoCorruptException(String message) {
            super(message);
        }
    }

    static class InfoUnavailableException
    extends FileManagerException {
        public InfoUnavailableException(String message) {
            super(message);
        }
    }

    static class ObjectNotFoundException
    extends FileManagerException {
        public ObjectNotFoundException(String message) {
            super(message);
        }
    }

    public static class FileManagerException
    extends IOException {
        private Exception _e;

        protected FileManagerException(String message) {
            super(message);
        }

        void setException(Exception e) {
            this._e = e;
        }

        Exception getException() {
            return this._e;
        }
    }
}

