/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.JDBMComparator;
import java.io.IOException;
import jdbm.btree.BTree;
import jdbm.hash.HTree;
import jdbm.helper.CachePolicy;
import jdbm.helper.Comparator;
import jdbm.helper.ObjectCache;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.recman.RecordManager;

public class JDBMHelper {
    public static final String DELIMITER_EXT = "$";
    private static final String NAME_STORE_TREE = "$Store";
    private static final String NAME_STATE_TREE = "$State";
    private static final String KEY_VERSION = "$version";
    private static final String KEY_CONTEXT = "$context";
    static final int JDBM_VERSION = 1;
    private static final int NOT_FOUND = 0;
    private static final int NUM_EXTENSIONS = 1;
    private static final String[] EXTENSIONS = new String[1];
    private RecordManager _recman;
    private ObjectCache _cache;
    private HTree _state;
    private BTree _store;
    private int _version;
    private String _context;
    private TupleBrowser browser;

    public JDBMHelper(String recmanName, CachePolicy policy) throws IOException {
        this._recman = new RecordManager(recmanName);
        this._cache = new ObjectCache(this._recman, policy);
        this._state = this.getHTree(NAME_STATE_TREE);
        this._store = this.getBTree(NAME_STORE_TREE);
    }

    public BTree getBTree(String treeName) throws IOException {
        BTree tree;
        long recManId = this._recman.getNamedObject(treeName);
        if (recManId == 0L) {
            tree = new BTree(this._recman, this._cache, (Comparator)JDBMComparator.INSTANCE);
            this._recman.setNamedObject(treeName, tree.getRecid());
        } else {
            tree = BTree.load((RecordManager)this._recman, (ObjectCache)this._cache, (long)recManId);
        }
        return tree;
    }

    public HTree getHTree(String treeName) throws IOException {
        HTree tree;
        long id = this._recman.getNamedObject(treeName);
        if (id == 0L) {
            tree = new HTree(this._recman, this._cache);
            this._recman.setNamedObject(treeName, tree.getRecid());
        } else {
            tree = HTree.load((RecordManager)this._recman, (ObjectCache)this._cache, (long)id);
        }
        return tree;
    }

    public void setVersion(int version) throws IOException {
        this._state.put((Object)KEY_VERSION, (Object)new Integer(version));
    }

    public int getVersion() {
        return this._version;
    }

    public void setContext(String context) throws IOException {
        this._state.put((Object)KEY_CONTEXT, (Object)context);
    }

    public String getContext() {
        return this._context;
    }

    public void commit() throws IOException {
        this._recman.commit();
    }

    public boolean close() {
        try {
            this._recman.close();
            return true;
        }
        catch (IOException io) {
            return false;
        }
    }

    public void deleteObjects(String name) throws IOException {
        for (int e = 0; e < 1; ++e) {
            long id = this._recman.getNamedObject(name + EXTENSIONS[e]);
            if (id == 0L) continue;
            this._recman.delete(id);
        }
    }

    public Tuple getFirst() throws IOException {
        return this._store.findGreaterOrEqual((Object)new Long(0L));
    }

    public Tuple getLast() throws IOException {
        Tuple retrec = new Tuple();
        this.browser = this._store.browse(null);
        if (!this.browser.getPrevious(retrec)) {
            retrec.setKey((Object)new Long(0L));
            retrec.setValue(null);
        }
        return retrec;
    }

    public void replace(Long key, Object value) throws IOException {
        this._store.insert((Object)key, value, true);
    }

    public void put(Object value) throws IOException {
        Tuple rec = this.getLast();
        Long key = (Long)rec.getKey();
        long ri = key;
        key = new Long(++ri);
        this._store.insert((Object)key, value, false);
    }

    public String remove(Long key) throws IOException {
        String retval = (String)this._store.remove((Object)key);
        return retval;
    }

    static {
        for (int e = 0; e < 1; ++e) {
            JDBMHelper.EXTENSIONS[e] = DELIMITER_EXT + e;
        }
    }
}

