/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.ComposerPublicationShim;
import com.novell.idm.driver.InputDocumentAtomizer;
import com.novell.idm.driver.JDBMHelper;
import com.novell.nds.dirxml.driver.XmlDocument;
import org.w3c.dom.Document;

public class PublisherProducer
extends Thread {
    private JDBMHelper jdbm;
    private ComposerPublicationShim pShim;
    private String publisherGetEventsMethod;

    public PublisherProducer(ComposerPublicationShim comp, JDBMHelper jdbm) {
        this.jdbm = jdbm;
        this.pShim = comp;
        this.publisherGetEventsMethod = this.pShim.driverParams.get("ComposerServicePublisherGetEventsMethodName").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Document lInitDoc = this.pShim.composerService.CreateDocFromString("<root/>");
        while (!this.pShim.isShutdown()) {
            Document lReturnDoc = null;
            try {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: run() calling Composer WebService: " + this.publisherGetEventsMethod, 3);
                lReturnDoc = this.pShim.composerService.callComposerService(lInitDoc, this.publisherGetEventsMethod);
            }
            catch (Exception e) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: WebService threw exception", 5);
            }
            if (lReturnDoc == null) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: lReturnDoc = null");
            }
            if (lReturnDoc.getDocumentElement() == null) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: lReturnDoc.getDocumentElement() = null");
            }
            if (!lReturnDoc.getDocumentElement().hasChildNodes()) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: lReturnDoc.getDocumentElement().hasChildNodes()");
            }
            if (lReturnDoc != null && lReturnDoc.getDocumentElement() != null && lReturnDoc.getDocumentElement().hasChildNodes()) {
                try {
                    Object object;
                    Document target;
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: " + this.publisherGetEventsMethod + " Returned", 3);
                    this.pShim.trace.trace(new XmlDocument(lReturnDoc), 5);
                    InputDocumentAtomizer da = new InputDocumentAtomizer(lReturnDoc);
                    while ((target = da.constructSingleInputElementDocument()) != null) {
                        try {
                            XmlDocument xmlDoc = new XmlDocument(target);
                            this.pShim.trace.trace("PublisherShim\\PublisherProducer: Atomized Document", 3);
                            this.pShim.trace.trace(xmlDoc, 5);
                            Object object2 = this.pShim.mSemaphore;
                            synchronized (object2) {
                                this.jdbm.put(xmlDoc.getDocumentString());
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        object = this.pShim.mSemaphore;
                        synchronized (object) {
                            this.pShim.mSemaphore.notifyAll();
                        }
                    }
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: *******************", 3);
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: waiting to poll ...", 3);
                    object = this.pShim.mSemaphore;
                    synchronized (object) {
                        this.pShim.mSemaphore.wait((int)this.pShim.getPublisherPollingInterval());
                    }
                    if (!this.pShim.isShutdown()) continue;
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: found shutdown = true", 5);
                }
                catch (Exception e) {
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: exception caught" + e.getMessage(), 5);
                }
                continue;
            }
            this.pShim.trace.trace("PublisherShim\\PublisherProducer: getEvents returned error", 5);
            if (lReturnDoc != null) {
                this.pShim.trace.trace(" " + lReturnDoc, 3);
            } else {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: returned null document", 5);
            }
            try {
                Thread.sleep(this.pShim.getPublisherPollingInterval());
            }
            catch (Exception exception) {}
        }
        this.pShim.trace.trace("PublisherShim\\PublisherProducer: Received Shutdown Notification", 5);
    }
}

