/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.CommonImpl;
import com.novell.idm.driver.ComposerPublicationShim;
import com.novell.idm.driver.ComposerServiceHelper;
import com.novell.idm.driver.ComposerSubscriptionShim;
import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RequiredConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.HashMap;

public class ComposerDriverShim
extends CommonImpl
implements DriverShim {
    private static final String DEFAULT_PASSWORD = null;
    ComposerServiceHelper mComposerService;
    ComposerSubscriptionShim mSubscriptionShim;
    ComposerPublicationShim mPublicationShim;
    String driverCachePath;

    public ComposerDriverShim() {
        super("ComposerDriverShim");
        this.setDriverRDN("ComposerDriverShim");
        this.setTrace(null);
        this.setDriverParams();
    }

    private void setDriverParams() {
        this.driverParams = new HashMap(8);
        Parameter parameter = new Parameter("ComposerContext", null, DataType.STRING);
        parameter.add((Constraint)RequiredConstraint.REQUIRED);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServiceDriverInitMethodName", "Initialize", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServiceDriverGetSchemaMethodName", "GetSchema", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServiceDriverShutdownMethodName", "Shutdown", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerDriverCachePath", ".", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerDriverCachePolicyMax", "100", DataType.INT);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServicePublisherInitMethodName", "InitializePublisher", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServicePublisherGetEventsMethodName", "GetEvents", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServiceSubscriberInitMethodName", "InitializeSubscriber", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("ComposerServiceSubscriberExecuteMethodName", "Execute", DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        String string;
        String string2;
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            this.trace.trace("Init: DriverDn = " + xDSInitDocument.srcDN());
            this.setDriverDN(xDSInitDocument.srcDN());
            this.trace.trace("Init: getDriverDn = " + this.getDriverDN());
            xDSInitDocument.parameters(this.driverParams);
            string2 = this.driverParams.get("ComposerContext").toString();
            string = this.driverParams.get("ComposerServiceDriverInitMethodName").toString();
            this.driverCachePath = this.driverParams.get("ComposerDriverCachePath").toString();
            this.trace.trace("Init: ComposerServiceContext = " + string2, 3);
            this.trace.trace("Init: ComposerServiceDriverInitMethodName = " + string, 3);
            this.trace.trace("Init: ComposerServiceDriverGetSchemaMethodName = " + this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServiceDriverShutdownMethodName = " + this.driverParams.get("ComposerServiceDriverShutdownMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServicePublisherInitMethodName = " + this.driverParams.get("ComposerServicePublisherInitMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServicePublisherGetEventsMethodName = " + this.driverParams.get("ComposerServicePublisherGetEventsMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServiceSubsriberInitMethodName = " + this.driverParams.get("ComposerServiceSubscriberInitMethodName").toString(), 3);
            this.trace.trace("Init: ComposerServiceSubsriberExecuteMethodName = " + this.driverParams.get("ComposerServiceSubscriberExecuteMethodName").toString(), 3);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
            return xDSResultDocument.toXML();
        }
        this.mComposerService = new ComposerServiceHelper(string2);
        this.mSubscriptionShim = new ComposerSubscriptionShim(this, this.mComposerService);
        this.mPublicationShim = new ComposerPublicationShim(this, this.mComposerService);
        this.trace.trace("init() calling Composer WebService: " + string, 3);
        return this.mComposerService.callComposerService(xmlDocument, string);
    }

    public XmlDocument shutdown(XmlDocument xmlDocument) {
        this.mPublicationShim.stop();
        String string = this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString();
        this.trace.trace("getSchema calling Composer WebService: " + string, 3);
        String string2 = this.driverParams.get("ComposerServiceDriverShutdownMethodName").toString();
        this.trace.trace("shutdown() calling Composer WebService: " + string2, 3);
        return this.mComposerService.callComposerService(xmlDocument, string2);
    }

    public SubscriptionShim getSubscriptionShim() {
        return this.mSubscriptionShim;
    }

    public XmlDocument getSchema(XmlDocument xmlDocument) {
        String string;
        Object object;
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        try {
            object = new XDSInitDocument(xmlDocument);
            object.parameters(this.driverParams);
            string = this.driverParams.get("ComposerContext").toString();
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
            return xDSResultDocument.toXML();
        }
        this.mComposerService = new ComposerServiceHelper(string);
        object = this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString();
        this.trace.trace("getSchema() calling Composer WebService: " + (String)object, 3);
        return this.mComposerService.callComposerService(xmlDocument, this.driverParams.get("ComposerServiceDriverGetSchemaMethodName").toString());
    }

    public PublicationShim getPublicationShim() {
        return this.mPublicationShim;
    }

    public String getDriverCachePath() {
        return this.driverCachePath;
    }
}

