/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.CommonImpl;
import com.novell.idm.driver.ComposerDriverShim;
import com.novell.idm.driver.ComposerServiceHelper;
import com.novell.idm.driver.DriverException;
import com.novell.idm.driver.JDBMFileManager;
import com.novell.idm.driver.JDBMHelper;
import com.novell.idm.driver.PublisherConsumer;
import com.novell.idm.driver.PublisherProducer;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;

public class ComposerPublicationShim
extends CommonImpl
implements PublicationShim,
XmlQueryProcessor {
    private Map pubParams;
    private static final String TRACE_SUFFIX = "PublisherShim";
    private static final int NO_OF_PARAMS = 2;
    private static final String TAG_POLLING_INTERVAL = "pollingInterval";
    private static final String DEFAULT_POLLING_INTERVAL = "10";
    private static final String DRIVER_CACHE_FILE_PREFIX = "cmpsrCache";
    protected JDBMHelper cache;
    private XmlCommandProcessor processor;
    private JDBMFileManager fileman;
    boolean shutdown = false;
    private long pollingInterval;
    Object mSemaphore = new Object();
    Object shutdownSemaphore = new Object();
    private ComposerDriverShim driver;
    public ComposerServiceHelper composerService;

    protected ComposerPublicationShim(ComposerDriverShim composerDriverShim, ComposerServiceHelper composerServiceHelper) {
        super("ComposerPublicationShim");
        this.composerService = composerServiceHelper;
        this.driver = composerDriverShim;
        this.setDriverRDN(composerDriverShim.getDriverRDN());
        this.setTrace(TRACE_SUFFIX);
        this.setDriverParams(composerDriverShim.getDriverParams());
        this.pollingInterval = -1L;
        this.setPubParams();
    }

    private void setPubParams() {
        this.pubParams = new HashMap(2);
        Parameter parameter = new Parameter(TAG_POLLING_INTERVAL, DEFAULT_POLLING_INTERVAL, DataType.INT);
        parameter.add((Constraint)RangeConstraint.NON_NEGATIVE);
        this.pubParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 3);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            xDSInitDocument.parameters(this.pubParams);
            Parameter parameter = (Parameter)this.pubParams.get(TAG_POLLING_INTERVAL);
            if (parameter.toString().equals("0")) {
                parameter.overrideValue(DEFAULT_POLLING_INTERVAL);
                this.trace.trace("Received PollingInterval 0  Set to 10 seconds", 3);
            } else {
                this.trace.trace("Received PollingInterval(min) " + parameter.toString(), 3);
                parameter.overrideValue(new Integer(parameter.toInteger() * 60).toString());
            }
            this.pollingInterval = XDSUtil.toMillis((int)parameter.toInteger());
            this.trace.trace("Polling Interval(millis) " + this.pollingInterval, 5);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
            return xDSResultDocument.toXML();
        }
        return this.composerService.callComposerService(xmlDocument, this.driverParams.get("ComposerServicePublisherInitMethodName").toString());
    }

    public XmlDocument start(XmlCommandProcessor xmlCommandProcessor) {
        Object object;
        this.composerService.mComposerSession.put("idm2QueryProcessor", xmlCommandProcessor);
        this.setCommandProcessor(xmlCommandProcessor);
        try {
            this.trace.trace("Setting up Publisher Cache");
            object = this.setupDatabase();
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.trace.trace("Entering Publishser Producer", 5);
        object = new PublisherProducer(this, this.cache);
        this.trace.trace("Entering Publisher Consumer", 5);
        PublisherConsumer publisherConsumer = new PublisherConsumer(this, this.cache, xmlCommandProcessor);
        ((Thread)object).start();
        publisherConsumer.monitor();
        try {
            this.trace.trace("Join waiting for publisherProducer to die", 5);
            ((Thread)object).join();
            this.trace.trace("after Join:  publisherProducer died successfully", 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
        XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
        return xDSResultDocument.toXML();
    }

    public void setCommandProcessor(XmlCommandProcessor xmlCommandProcessor) {
        this.processor = xmlCommandProcessor;
    }

    public XmlCommandProcessor getCommandProcessor() {
        return this.processor;
    }

    public long getPublisherPollingInterval() {
        return this.pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.shutdownSemaphore;
        synchronized (object) {
            this.trace.trace("Stop Received...Setting shutdown to True", 5);
            this.shutdown = true;
        }
        object = this.mSemaphore;
        synchronized (object) {
            this.mSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isShutdown() {
        Object object = this.shutdownSemaphore;
        synchronized (object) {
            return this.shutdown;
        }
    }

    public XmlDocument query(XmlDocument xmlDocument) {
        this.trace.trace("Calling Query Execute", 3);
        XmlDocument xmlDocument2 = this.composerService.callComposerService(xmlDocument, this.driverParams.get("ComposerServiceSubscriberExecuteMethodName").toString());
        this.trace.trace("Query Execute Returned", 3);
        this.trace.trace(xmlDocument2, 3);
        return xmlDocument2;
    }

    private void newRecordManager() throws IOException {
        Parameter parameter = (Parameter)this.driver.driverParams.get("ComposerDriverCachePolicyMax");
        this.cache = new JDBMHelper(this.fileman.getUniqueFileName(), (CachePolicy)new MRU(parameter.toInteger().intValue()));
    }

    private XmlDocument setupDatabase() throws IOException, DriverException {
        StatusAttributes statusAttributes;
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        String string = this.driver.getDriverDN();
        if ("".compareTo(string) == 0 || string == null) {
            throw new DriverException("Missing required driver DN in driver shim initialization document.", StatusLevel.FATAL);
        }
        JDBMFileManager.QueryProcessor queryProcessor = new JDBMFileManager.QueryProcessor(this.getCommandProcessor(), this);
        this.trace.trace("Database Setup..DriverDN = " + string);
        this.trace.trace("Database Setup..CachePath = " + this.driver.getDriverCachePath());
        this.trace.trace("Database Setup..CachePrefix = cmpsrCache");
        this.fileman = new JDBMFileManager(string, this.driver.getDriverCachePath(), DRIVER_CACHE_FILE_PREFIX, queryProcessor);
        this.trace.trace("This driver's GUID:  " + this.fileman.getGUID(), 3);
        try {
            this.newRecordManager();
        }
        catch (IOException iOException) {
            if (this.fileman.deleteFiles()) {
                this.newRecordManager();
            }
            throw iOException;
        }
        if (this.isDifferentHost()) {
            this.trace.trace("Host change detected.  Deleting state files.", 3);
            statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, (String)"Publisher state file version conflict detected.  Deleting state files.", null, (boolean)false, null);
            this.fileman.deleteFiles();
        }
        if (this.fileman.filesAlreadyPresent() && 1 != this.cache.getVersion()) {
            this.trace.trace("Publisher state file version conflict detected.  Deleting state files.", 3);
            statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, (String)"Publisher state file version conflict detected.  Deleting state files.", null, (boolean)false, null);
            this.fileman.deleteFiles();
        } else {
            this.cache.setVersion(1);
            this.cache.setContext(this.driver.mComposerService.mComposerContext);
            this.cache.commit();
        }
        if (!xDSResultDocument.isEmpty()) {
            return xDSResultDocument.toXML();
        }
        return null;
    }

    private boolean isDifferentHost() throws DriverException {
        return this.cache.getContext().equals(this.driver.mComposerService.mComposerContext);
    }
}

