/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.xml.dom.DOMQuery;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.xpath.NodeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InputDocumentAtomizer {
    private Document srcDoc;
    private int currentInputChildIndex;

    public InputDocumentAtomizer(Document document) {
        this.srcDoc = document;
        this.currentInputChildIndex = 0;
    }

    public Node getNdsNode() {
        Element element = null;
        element = this.srcDoc.getDocumentElement();
        if (!element.getNodeName().equals("nds")) {
            element = null;
        }
        return element;
    }

    public Node getSourceNode() {
        Node node = null;
        DOMQuery dOMQuery = new DOMQuery("nds/source");
        try {
            NodeSet nodeSet = dOMQuery.evaluate((Node)this.srcDoc);
            if (!nodeSet.isEmpty()) {
                node = nodeSet.first();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    public Node getInputNode() {
        Node node = null;
        DOMQuery dOMQuery = new DOMQuery("nds/input");
        try {
            NodeSet nodeSet = dOMQuery.evaluate((Node)this.srcDoc);
            if (!nodeSet.isEmpty()) {
                node = nodeSet.first();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    public Node readInputChildNode() {
        NodeList nodeList;
        Node node = null;
        Node node2 = this.getInputNode();
        if (node2 != null && (nodeList = node2.getChildNodes()).getLength() > 0) {
            while (this.currentInputChildIndex < nodeList.getLength() && (node = nodeList.item(this.currentInputChildIndex)).getNodeType() != 1) {
                ++this.currentInputChildIndex;
            }
            node = nodeList.item(this.currentInputChildIndex++);
        }
        return node;
    }

    public Document constructSingleInputElementDocument() throws DOMException {
        Document document = DocumentFactory.newDocument();
        Node node = this.getNdsNode();
        if (node != null) {
            Node node2 = document.appendChild(document.importNode(node, false));
            Node node3 = this.getSourceNode();
            if (node3 != null) {
                node2.appendChild(document.importNode(node3, true));
            }
            Node node4 = null;
            Node node5 = this.getInputNode();
            if (node5 != null) {
                Node node6 = node2.appendChild(document.importNode(this.getInputNode(), false));
                Node node7 = null;
                node7 = this.readInputChildNode();
                if (node7 != null) {
                    node4 = node6.appendChild(document.importNode(node7, true));
                }
            }
            if (node5 == null || node4 == null) {
                document = null;
            }
        }
        return document;
    }
}

