/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.DOMUtil;
import com.novell.idm.driver.GUIDTranslator;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.xml.util.Base64Codec;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JDBMFileManager {
    private static final String SEPARATOR = "_";
    private static final int LENGTH_BUFFER = 1024;
    private static final int LENGTH_MAX_FILE_NAME = 256;
    private static final int LENGTH_EXTENSION = 3;
    public static final String EXTENSION_DATABASE;
    public static final String EXTENSION_LOG;
    private static final String[] EXTENSIONS;
    private static final int NUM_EXTENSIONS;
    private static final String[] CURRENT_DIRS;
    private String _dn;
    private String _prefix;
    private String _path;
    private QueryProcessor _processor;
    private String _fileName;
    private List _guids;
    private String _guid;
    private Map _orphanedFiles;
    private StringBuffer _buffer;
    private boolean _forwardSlash;
    private boolean _filesPresent;

    private static boolean isJDBMExtension(String string) {
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            if (!EXTENSIONS[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCurrentDir(String string) {
        for (int i = 0; i < CURRENT_DIRS.length; ++i) {
            if (!CURRENT_DIRS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public JDBMFileManager(String string, String string2, String string3, QueryProcessor queryProcessor) throws FileManagerException {
        this.setDN(string);
        this.setPath(string2);
        this.setPrefix(string3);
        this.setProcessor(queryProcessor);
        this._guids = new ArrayList();
        this._orphanedFiles = new HashMap();
        this._buffer = new StringBuffer(LENGTH_BUFFER);
        this.setGUIDs();
        this.queryForGUIDs();
        this.deleteOrphanedFiles();
        System.out.println("JDBMFileManager Calling generateUniqueFileName");
        this.generateUniqueFileName();
        System.out.println("JDBMFileManager FileName = " + this._fileName);
    }

    private void setDN(String string) {
        if (DOMUtil.noValue(string)) {
            throw new IllegalArgumentException("Object DN is null or empty string.");
        }
        this._dn = string;
    }

    private void setPath(String string) {
        if (DOMUtil.noValue(string)) {
            throw new IllegalArgumentException("Directory path is null or empty string.");
        }
        this._path = string;
        if (this._path.indexOf(47) != -1) {
            this._forwardSlash = true;
        }
    }

    private void setPrefix(String string) {
        if (DOMUtil.noValue(string)) {
            throw new IllegalArgumentException("File name prefix is null or empty string.");
        }
        if (string.length() + SEPARATOR.length() + 36 + LENGTH_EXTENSION > LENGTH_MAX_FILE_NAME) {
            throw new IllegalArgumentException("File name prefix is too long.");
        }
        this._prefix = string;
    }

    private void setProcessor(QueryProcessor queryProcessor) {
        if (queryProcessor == null) {
            throw new IllegalArgumentException("QueryProcessor instance is null.");
        }
        this._processor = queryProcessor;
    }

    public String getUniqueFileName() {
        return this._fileName;
    }

    public boolean filesAlreadyPresent() {
        return this._filesPresent;
    }

    private void generateUniqueFileName() {
        this._buffer.delete(0, this._buffer.length());
        this._buffer.append(this._path);
        char c = this._path.charAt(this._path.length() - 1);
        if (c != '/' && c != '\\') {
            if (this._forwardSlash) {
                this._buffer.append('/');
            } else {
                this._buffer.append('\\');
            }
        }
        this._buffer.append(this._prefix);
        this._buffer.append(SEPARATOR);
        this._buffer.append(this._guid);
        this._fileName = this._buffer.toString().toLowerCase();
        this._buffer = null;
    }

    public String getGUID() {
        return this._guid;
    }

    private void setGUIDs() throws FileManagerException {
        File[] fileArray;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                int n = JDBMFileManager.this._prefix.length() + SEPARATOR.length() + 36 + LENGTH_EXTENSION;
                int n2 = string.length() - LENGTH_EXTENSION;
                return string.length() == n && JDBMFileManager.this._prefix.equalsIgnoreCase(string.substring(0, JDBMFileManager.this._prefix.length())) && JDBMFileManager.isJDBMExtension(string.substring(n2, string.length()));
            }
        };
        File file = new File(this._path);
        if (!JDBMFileManager.isCurrentDir(this._path)) {
            if (!file.mkdirs()) {
                throw new FileManagerException("Unable to create directories '" + this._path + "'.");
            }
            if (!file.isDirectory()) {
                file.delete();
                throw new FileManagerException("Path '" + this._path + "' is not a directory.");
            }
        }
        if ((fileArray = file.listFiles(filenameFilter)) == null) {
            throw new FileManagerException("Path '" + this._path + "' is not a directory, does not exist, or is not accessible.");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            file = fileArray[i];
            String string = file.getName();
            String string2 = string.substring(this._prefix.length() + SEPARATOR.length(), string.length() - LENGTH_EXTENSION);
            if (GUIDTranslator.isValid(string2 = string2.toUpperCase())) {
                ArrayList<File> arrayList;
                if (!this._guids.contains(string2)) {
                    this._guids.add(string2);
                }
                if ((arrayList = (ArrayList<File>)this._orphanedFiles.get(string2)) == null) {
                    arrayList = new ArrayList<File>(NUM_EXTENSIONS);
                    this._orphanedFiles.put(string2, arrayList);
                }
                arrayList.add(file);
                continue;
            }
            this.delete(file);
        }
    }

    private boolean delete(File file) {
        try {
            return file.delete();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public boolean deleteFiles() {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(JDBMFileManager.this._fileName);
            }
        };
        File[] fileArray = new File(this._path).listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.delete(fileArray[i])) continue;
            return false;
        }
        return true;
    }

    private void queryForGUIDs() throws FileManagerException {
        this._buffer.delete(0, this._buffer.length());
        this._buffer.append("<nds>");
        this._buffer.append("<input>");
        this._buffer.append("<query scope=\"entry\" ");
        this._buffer.append("dest-dn=\"" + this._dn + "\">");
        this._buffer.append("<read-attr attr-name=\"GUID\"/>");
        this._buffer.append("</query>");
        ListIterator listIterator = this._guids.listIterator();
        while (listIterator.hasNext()) {
            char[] cArray = Base64Codec.encode((byte[])GUIDTranslator.stringGuidtoBin((String)listIterator.next()));
            this._buffer.append("<query>");
            this._buffer.append("<search-attr attr-name=\"GUID\">");
            this._buffer.append("<value type=\"octet\">");
            this._buffer.append(cArray);
            this._buffer.append("</value>");
            this._buffer.append("</search-attr>");
            this._buffer.append("<read-attr attr-name=\"GUID\"/>");
            this._buffer.append("</query>");
        }
        this._buffer.append("</input>");
        this._buffer.append("</nds>");
        XmlDocument xmlDocument = new XmlDocument(this._buffer.toString());
        Document document = this._processor.query(xmlDocument).getDocument();
        this.getGUIDValues(document.getElementsByTagName("value"));
    }

    private void getGUIDValues(NodeList nodeList) throws FileManagerException {
        if (nodeList.getLength() < 1) {
            throw new ObjectNotFoundException("Object '" + this._dn + "' does not exist.");
        }
        Element element = (Element)nodeList.item(0);
        String string = DOMUtil.getChildText(element);
        if (string == null) {
            throw new InfoUnavailableException("Unable to read GUID for object '" + this._dn + "'.");
        }
        byte[] byArray = this.decode(string);
        if (byArray == null) {
            throw new InfoUnavailableException("Unable to read GUID for object '" + this._dn + "'.");
        }
        this._guid = GUIDTranslator.binGuidToString(byArray);
        for (int i = 1; i < nodeList.getLength(); ++i) {
            element = (Element)nodeList.item(i);
            string = DOMUtil.getChildText(element);
            if (string == null || (byArray = this.decode(string)) == null) continue;
            string = GUIDTranslator.binGuidToString(byArray);
            if (!this._filesPresent && string.compareTo(this._guid) == 0) {
                this._filesPresent = true;
            }
            this._orphanedFiles.remove(string);
        }
    }

    private byte[] decode(String string) throws InfoCorruptException {
        try {
            return Base64Codec.decode((String)string);
        }
        catch (IOException iOException) {
            InfoCorruptException infoCorruptException = new InfoCorruptException("Unable to decode GUID '" + string + "'.");
            infoCorruptException.setException(iOException);
            throw infoCorruptException;
        }
    }

    private void deleteOrphanedFiles() {
        Iterator iterator = this._orphanedFiles.values().iterator();
        while (iterator.hasNext()) {
            ListIterator listIterator = ((List)iterator.next()).listIterator();
            while (listIterator.hasNext()) {
                this.delete((File)listIterator.next());
            }
        }
    }

    static {
        NUM_EXTENSIONS = 2;
        EXTENSION_DATABASE = ".db";
        EXTENSION_LOG = ".lg";
        EXTENSIONS = new String[NUM_EXTENSIONS];
        JDBMFileManager.EXTENSIONS[0] = EXTENSION_DATABASE;
        JDBMFileManager.EXTENSIONS[1] = EXTENSION_LOG;
        CURRENT_DIRS = new String[]{".", "." + File.pathSeparator};
    }

    public static class QueryProcessor {
        private XmlCommandProcessor _command;
        private XmlQueryProcessor _query;

        public QueryProcessor(XmlCommandProcessor xmlCommandProcessor, XmlQueryProcessor xmlQueryProcessor) {
            if (xmlCommandProcessor == null) {
                throw new IllegalArgumentException("Command processor is null.");
            }
            if (xmlQueryProcessor == null) {
                throw new IllegalArgumentException("Query processor is null.");
            }
            this._command = xmlCommandProcessor;
            this._query = xmlQueryProcessor;
        }

        public QueryProcessor(XmlQueryProcessor xmlQueryProcessor) {
            if (xmlQueryProcessor == null) {
                throw new IllegalArgumentException("Query processor is null.");
            }
            this._query = xmlQueryProcessor;
        }

        XmlDocument query(XmlDocument xmlDocument) {
            if (this._command == null) {
                return this._query.query(xmlDocument);
            }
            return this._command.execute(xmlDocument, this._query);
        }
    }

    static class InfoCorruptException
    extends FileManagerException {
        public InfoCorruptException(String string) {
            super(string);
        }
    }

    static class InfoUnavailableException
    extends FileManagerException {
        public InfoUnavailableException(String string) {
            super(string);
        }
    }

    static class ObjectNotFoundException
    extends FileManagerException {
        public ObjectNotFoundException(String string) {
            super(string);
        }
    }

    public static class FileManagerException
    extends IOException {
        private Exception _e;

        protected FileManagerException(String string) {
            super(string);
        }

        void setException(Exception exception) {
            this._e = exception;
        }

        Exception getException() {
            return this._e;
        }
    }
}

