/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.JDBMComparator;
import java.io.IOException;
import jdbm.btree.BTree;
import jdbm.hash.HTree;
import jdbm.helper.CachePolicy;
import jdbm.helper.Comparator;
import jdbm.helper.ObjectCache;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.recman.RecordManager;

public class JDBMHelper {
    public static final String DELIMITER_EXT = "$";
    private static final String NAME_STORE_TREE = "$Store";
    private static final String NAME_STATE_TREE = "$State";
    private static final String KEY_VERSION = "$version";
    private static final String KEY_CONTEXT = "$context";
    static final int JDBM_VERSION = 1;
    private static final int NOT_FOUND = 0;
    private static final int NUM_EXTENSIONS = 1;
    private static final String[] EXTENSIONS = new String[1];
    private RecordManager _recman;
    private ObjectCache _cache;
    private HTree _state;
    private BTree _store;
    private int _version;
    private String _context;
    private TupleBrowser browser;

    public JDBMHelper(String string, CachePolicy cachePolicy) throws IOException {
        this._recman = new RecordManager(string);
        this._cache = new ObjectCache(this._recman, cachePolicy);
        this._state = this.getHTree(NAME_STATE_TREE);
        this._store = this.getBTree(NAME_STORE_TREE);
    }

    public BTree getBTree(String string) throws IOException {
        BTree bTree;
        long l = this._recman.getNamedObject(string);
        if (l == 0L) {
            bTree = new BTree(this._recman, this._cache, (Comparator)JDBMComparator.INSTANCE);
            this._recman.setNamedObject(string, bTree.getRecid());
        } else {
            bTree = BTree.load((RecordManager)this._recman, (ObjectCache)this._cache, (long)l);
        }
        return bTree;
    }

    public HTree getHTree(String string) throws IOException {
        HTree hTree;
        long l = this._recman.getNamedObject(string);
        if (l == 0L) {
            hTree = new HTree(this._recman, this._cache);
            this._recman.setNamedObject(string, hTree.getRecid());
        } else {
            hTree = HTree.load((RecordManager)this._recman, (ObjectCache)this._cache, (long)l);
        }
        return hTree;
    }

    public void setVersion(int n) throws IOException {
        this._state.put((Object)KEY_VERSION, (Object)new Integer(n));
    }

    public int getVersion() {
        return this._version;
    }

    public void setContext(String string) throws IOException {
        this._state.put((Object)KEY_CONTEXT, (Object)string);
    }

    public String getContext() {
        return this._context;
    }

    public void commit() throws IOException {
        this._recman.commit();
    }

    public boolean close() {
        try {
            this._recman.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void deleteObjects(String string) throws IOException {
        for (int i = 0; i < 1; ++i) {
            long l = this._recman.getNamedObject(string + EXTENSIONS[i]);
            if (l == 0L) continue;
            this._recman.delete(l);
        }
    }

    public Tuple getFirst() throws IOException {
        return this._store.findGreaterOrEqual((Object)new Long(0L));
    }

    public Tuple getLast() throws IOException {
        Tuple tuple = new Tuple();
        this.browser = this._store.browse(null);
        if (!this.browser.getPrevious(tuple)) {
            tuple.setKey((Object)new Long(0L));
            tuple.setValue(null);
        }
        return tuple;
    }

    public void replace(Long l, Object object) throws IOException {
        this._store.insert((Object)l, object, true);
    }

    public void put(Object object) throws IOException {
        Tuple tuple = this.getLast();
        Long l = (Long)tuple.getKey();
        long l2 = l;
        l = new Long(++l2);
        this._store.insert((Object)l, object, false);
    }

    public String remove(Long l) throws IOException {
        String string = (String)this._store.remove((Object)l);
        return string;
    }

    static {
        for (int i = 0; i < 1; ++i) {
            JDBMHelper.EXTENSIONS[i] = DELIMITER_EXT + i;
        }
    }
}

