/*
 * Decompiled with CFR 0.152.
 */
package com.novell.idm.driver;

import com.novell.idm.driver.ComposerPublicationShim;
import com.novell.idm.driver.InputDocumentAtomizer;
import com.novell.idm.driver.JDBMHelper;
import com.novell.nds.dirxml.driver.XmlDocument;
import org.w3c.dom.Document;

public class PublisherProducer
extends Thread {
    private JDBMHelper jdbm;
    private ComposerPublicationShim pShim;
    private String publisherGetEventsMethod;

    public PublisherProducer(ComposerPublicationShim composerPublicationShim, JDBMHelper jDBMHelper) {
        this.jdbm = jDBMHelper;
        this.pShim = composerPublicationShim;
        this.publisherGetEventsMethod = this.pShim.driverParams.get("ComposerServicePublisherGetEventsMethodName").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Document document = this.pShim.composerService.CreateDocFromString("<root/>");
        while (!this.pShim.isShutdown()) {
            Document document2 = null;
            try {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: run() calling Composer WebService: " + this.publisherGetEventsMethod, 3);
                document2 = this.pShim.composerService.callComposerService(document, this.publisherGetEventsMethod);
            }
            catch (Exception exception) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: WebService threw exception", 5);
            }
            if (document2 == null) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: lReturnDoc = null");
            }
            if (document2.getDocumentElement() == null) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: lReturnDoc.getDocumentElement() = null");
            }
            if (!document2.getDocumentElement().hasChildNodes()) {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: lReturnDoc.getDocumentElement().hasChildNodes()");
            }
            if (document2 != null && document2.getDocumentElement() != null && document2.getDocumentElement().hasChildNodes()) {
                try {
                    Object object;
                    Document document3;
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: " + this.publisherGetEventsMethod + " Returned", 3);
                    this.pShim.trace.trace(new XmlDocument(document2), 5);
                    InputDocumentAtomizer inputDocumentAtomizer = new InputDocumentAtomizer(document2);
                    while ((document3 = inputDocumentAtomizer.constructSingleInputElementDocument()) != null) {
                        try {
                            object = new XmlDocument(document3);
                            this.pShim.trace.trace("PublisherShim\\PublisherProducer: Atomized Document", 3);
                            this.pShim.trace.trace(object, 5);
                            Object object2 = this.pShim.mSemaphore;
                            synchronized (object2) {
                                this.jdbm.put(object.getDocumentString());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        object = this.pShim.mSemaphore;
                        synchronized (object) {
                            this.pShim.mSemaphore.notifyAll();
                        }
                    }
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: *******************", 3);
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: waiting to poll ...", 3);
                    object = this.pShim.mSemaphore;
                    synchronized (object) {
                        this.pShim.mSemaphore.wait((int)this.pShim.getPublisherPollingInterval());
                    }
                    if (!this.pShim.isShutdown()) continue;
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: found shutdown = true", 5);
                }
                catch (Exception exception) {
                    this.pShim.trace.trace("PublisherShim\\PublisherProducer: exception caught" + exception.getMessage(), 5);
                }
                continue;
            }
            this.pShim.trace.trace("PublisherShim\\PublisherProducer: getEvents returned error", 5);
            if (document2 != null) {
                this.pShim.trace.trace(" " + document2, 3);
            } else {
                this.pShim.trace.trace("PublisherShim\\PublisherProducer: returned null document", 5);
            }
            try {
                Thread.sleep(this.pShim.getPublisherPollingInterval());
            }
            catch (Exception exception) {}
        }
        this.pShim.trace.trace("PublisherShim\\PublisherProducer: Received Shutdown Notification", 5);
    }
}

