/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.StreamableInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1GenericPrimitive
implements ASN1TaggedObject {
    private ASN1Header header;
    private byte[] body;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public ASN1GenericPrimitive(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public ASN1GenericPrimitive(ASN1Object aSN1Object, int n, int n2) {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(Utils.toBytes(aSN1Object));
        try {
            ASN1Header aSN1Header = new ASN1Header(unsyncByteArrayInputStream);
            this.initialize(aSN1Header.readBody(unsyncByteArrayInputStream), n, n2);
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public ASN1GenericPrimitive(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericPrimitive(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, 128);
    }

    public ASN1GenericPrimitive(InputStream inputStream, int n, int n2) throws IOException {
        this.input(inputStream);
        this.header.checkTag(n);
        this.header.checkTagClass(n2);
    }

    public ASN1GenericPrimitive(byte[] byArray, int n) {
        this(byArray, n, 128);
    }

    public ASN1GenericPrimitive(byte[] byArray, int n, int n2) {
        this.initialize(byArray, n, n2);
    }

    public byte[] getBody() {
        return this.body;
    }

    public ASN1Header getHeader() {
        return this.header;
    }

    public int getTag() {
        return this.header.getTag();
    }

    public int getTagClass() {
        return this.header.getTagClass();
    }

    private void initialize(byte[] byArray, int n, int n2) {
        this.body = byArray;
        this.header = new ASN1Header(n, n2, 0, byArray.length);
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkEncodingMethod(0);
        this.initialize(aSN1Header.readBody(inputStream), aSN1Header.getTag(), aSN1Header.getTagClass());
    }

    public int length() {
        return this.header.totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        outputStream.write(this.body);
    }

    public ASN1Object withTag(int n) throws IOException {
        return this.withTag(n, 0);
    }

    public ASN1Object withTag(int n, int n2) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(n, n2, 0, this.body.length);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(aSN1Header.length() + this.body.length);
        aSN1Header.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(this.body);
        return ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(fixedByteArrayOutputStream.getBytes()));
    }
}

