/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Header
implements Streamable,
ASN1 {
    private int tag;
    private int tagClass;
    private int method;
    private int bodyLength;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public ASN1Header() {
    }

    public ASN1Header(int n, int n2) {
        this(n, n2, 2, -1);
    }

    public ASN1Header(int n, int n2, int n3, int n4) {
        this.tag = n;
        this.tagClass = n2;
        this.method = n3;
        this.bodyLength = n4;
    }

    public ASN1Header(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    int bodyLengthLength() {
        return 1 + (this.bodyLength < 128 ? 0 : ASN1Utils.lengthBase256(this.bodyLength));
    }

    public void checkEncodingMethod(int n) throws ASN1FormatException {
        if (this.method != n) {
            throw new ASN1FormatException("Got encoding method " + this.encodingMethodToString(this.method) + " instead of " + this.encodingMethodToString(n) + ".");
        }
    }

    public void checkTag(int n) throws ASN1FormatException {
        if (this.tag != n) {
            throw new ASN1FormatException("Got tag " + this.tag + " instead of " + n + ".");
        }
    }

    public void checkTagClass(int n) throws ASN1FormatException {
        if (this.tagClass != n) {
            throw new ASN1FormatException("Got tag class " + this.tagClassToString(this.tagClass) + " instead of " + this.tagClassToString(n) + ".");
        }
    }

    public String encodingMethodToString(int n) {
        String[] stringArray = new String[]{"primitive", "constructed", "constructed"};
        return stringArray[n];
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public int getEncodingMethod() {
        return this.method;
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public byte[] headerAndBody(InputStream inputStream) throws IOException {
        byte[] byArray = this.readBody(inputStream);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length() + byArray.length);
        this.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(byArray);
        return fixedByteArrayOutputStream.toByteArray();
    }

    public void input(InputStream inputStream) throws IOException {
        this.inputTag(inputStream);
        this.inputLength(inputStream);
    }

    void inputLength(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        if (n < 128) {
            this.bodyLength = n;
        } else if (n == 128) {
            this.method = 2;
            this.bodyLength = -1;
        } else {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new ASN1FormatException("Length is too big: takes " + n2 + " bytes");
            }
            this.bodyLength = 0;
            int n3 = 0;
            while (n3 < n2) {
                this.bodyLength <<= 8;
                this.bodyLength |= Utils.inputByte(inputStream) & 0xFF;
                ++n3;
            }
        }
    }

    void inputTag(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        this.tagClass = n & 0xC0;
        this.method = (n & 0x20) == 0 ? 0 : 1;
        this.tag = n & 0x1F;
        if (this.tag == 31) {
            this.tag = ASN1Utils.inputBase128(inputStream);
        }
    }

    public int length() {
        return this.tagLength() + this.bodyLengthLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputTag(outputStream);
        this.outputLength(outputStream);
    }

    void outputLength(OutputStream outputStream) throws IOException {
        if (this.method == 2) {
            outputStream.write(128);
        } else {
            ASN1Utils.outputLengthBytes(outputStream, this.bodyLength);
        }
    }

    void outputTag(OutputStream outputStream) throws IOException {
        int n = this.tag < 31 ? this.tag : 31;
        int n2 = this.tagClass | n;
        if (this.method != 0) {
            n2 |= 0x20;
        }
        outputStream.write(n2);
        if (this.tag >= 31) {
            ASN1Utils.outputBase128(this.tag, outputStream);
        }
    }

    public byte[] readBody(InputStream inputStream) throws IOException {
        if (this.method != 2) {
            byte[] byArray = new byte[this.bodyLength];
            Utils.inputByteArray(byArray, inputStream);
            return byArray;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        while (true) {
            ASN1Header aSN1Header = new ASN1Header();
            aSN1Header.input(inputStream);
            if (aSN1Header.tagClass == 0 && aSN1Header.tag == 0 && aSN1Header.bodyLength == 0) break;
            aSN1Header.output(unsyncByteArrayOutputStream);
            unsyncByteArrayOutputStream.write(aSN1Header.readBody(inputStream));
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public void skipBody(InputStream inputStream) throws IOException {
        if (this.method != 2) {
            int n = 0;
            while (n < this.bodyLength) {
                Utils.inputByte(inputStream);
                ++n;
            }
        } else {
            while (true) {
                ASN1Header aSN1Header = new ASN1Header();
                aSN1Header.input(inputStream);
                if (aSN1Header.tagClass == 0 && aSN1Header.tag == 0 && aSN1Header.bodyLength == 0) break;
                aSN1Header.skipBody(inputStream);
            }
        }
    }

    public String tagClassToString(int n) {
        String[] stringArray = new String[]{"universal", "application", "context-specific", "private"};
        return stringArray[n >> 6];
    }

    int tagLength() {
        return 1 + (this.tag < 31 ? 0 : ASN1Utils.lengthBase128(this.tag));
    }

    public String tagToString(int n) {
        String[] stringArray = new String[]{"END OF CONTENTS", "BOOLEAN", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "ObjectDescriptor", "EXTERNAL", "REAL", "ENUMERATED", "11", "12", "13", "14", "15", "SEQUENCE", "SET", "NumericString", "PrintableString", "T61String", "VideotexString", "IA5String", "UTCTime", "GeneralizedTime", "GraphicString", "VisibleString", "GeneralString", "UniversalString", "29", "BMPString"};
        return n < stringArray.length ? stringArray[n] : Integer.toString(n);
    }

    public String toString() {
        return String.valueOf(this.tagClassToString(this.tagClass)) + " " + (this.tagClass == 0 ? this.tagToString(this.tag) : Integer.toString(this.tag)) + " " + this.encodingMethodToString(this.method) + " length=" + (this.method == 2 ? "unknown" : Integer.toString(this.bodyLength));
    }

    public int totalLength() {
        return this.length() + this.bodyLength;
    }
}

