/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1Integer
implements ASN1TaggedObject {
    private ASN1Header header;
    private byte[] byteArrayValue;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public ASN1Integer(long l) {
        BigInt bigInt = BigInt.valueOf(l);
        this.initialize(bigInt);
        bigInt.erase();
    }

    public ASN1Integer(BigInt bigInt) {
        this.initialize(bigInt);
    }

    public ASN1Integer(InputStream inputStream) throws IOException {
        this.initialize(ASN1Integer.inputByteArrayValue(inputStream));
    }

    public ASN1Integer(BigInteger bigInteger) {
        this.initialize(bigInteger);
    }

    private static int bodyLength(BigInt bigInt) {
        return bigInt.bitLength() / 8 + 1;
    }

    private static int bodyLength(BigInteger bigInteger) {
        return bigInteger.bitLength() / 8 + 1;
    }

    private static int bodyLength(byte[] byArray) {
        BigInt bigInt = new BigInt(byArray);
        int n = bigInt.bitLength() / 8 + 1;
        bigInt.erase();
        return n;
    }

    public boolean equals(int n) {
        return this.intValue() == n;
    }

    public void erase() {
        if (this.byteArrayValue != null) {
            Utils.setArray(this.byteArrayValue, (byte)0);
        }
    }

    public void finalize() {
        this.erase();
    }

    public BigInt getBigIntValue() {
        return new BigInt(this.byteArrayValue);
    }

    public ASN1Header getHeader() {
        return this.header;
    }

    public BigInteger getValue() {
        return new BigInteger(this.byteArrayValue);
    }

    private void initialize(BigInt bigInt) {
        this.byteArrayValue = bigInt.toByteArray();
        this.header = new ASN1Header(2, 0, 0, ASN1Integer.bodyLength(bigInt));
    }

    private void initialize(BigInteger bigInteger) {
        this.byteArrayValue = bigInteger.toByteArray();
        this.header = new ASN1Header(2, 0, 0, ASN1Integer.bodyLength(bigInteger));
    }

    private void initialize(byte[] byArray) {
        this.byteArrayValue = byArray;
        this.header = new ASN1Header(2, 0, 0, ASN1Integer.bodyLength(byArray));
    }

    public void input(InputStream inputStream) throws IOException {
        this.initialize(ASN1Integer.inputByteArrayValue(inputStream));
    }

    public static BigInt inputBigIntValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return new BigInt(aSN1Header.readBody(inputStream));
    }

    public static byte[] inputByteArrayValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return aSN1Header.readBody(inputStream);
    }

    public static BigInteger inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(2);
        aSN1Header.checkEncodingMethod(0);
        return new BigInteger(aSN1Header.readBody(inputStream));
    }

    public int intValue() {
        BigInt bigInt = new BigInt(this.byteArrayValue);
        int n = bigInt.intValue();
        bigInt.erase();
        return n;
    }

    public int length() {
        return this.header.totalLength();
    }

    public long longValue() {
        BigInt bigInt = new BigInt(this.byteArrayValue);
        long l = bigInt.longValue();
        bigInt.erase();
        return l;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        outputStream.write(this.byteArrayValue);
    }

    public static void outputValue(OutputStream outputStream, int n) throws IOException {
        BigInt bigInt = BigInt.valueOf(n);
        ASN1Integer.outputValue(outputStream, bigInt);
        bigInt.erase();
    }

    private static void outputValue(OutputStream outputStream, BigInt bigInt) throws IOException {
        ASN1Integer.outputValueWithTag(outputStream, bigInt, 2, 0);
    }

    public static void outputValue(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        ASN1Integer.outputValueWithTag(outputStream, bigInteger, 2, 0);
    }

    private static void outputValueWithTag(OutputStream outputStream, BigInt bigInt, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, ASN1Integer.bodyLength(bigInt));
        outputStream.write(bigInt.toByteArray());
    }

    public static void outputValueWithTag(OutputStream outputStream, BigInteger bigInteger, int n) throws IOException {
        ASN1Integer.outputValueWithTag(outputStream, bigInteger, n, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, BigInteger bigInteger, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, ASN1Integer.bodyLength(bigInteger));
        outputStream.write(bigInteger.toByteArray());
    }

    public String toString() {
        BigInt bigInt = new BigInt(this.byteArrayValue);
        String string = "INTEGER " + bigInt.toString();
        bigInt.erase();
        return string;
    }
}

