/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.fips.FIPS_140_2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ASN1Sequence
implements ASN1TaggedObject,
ASN1Constructed {
    private Vector elements = new Vector();
    private ASN1Header header = null;
    private int bodyLength;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public ASN1Sequence() {
    }

    public ASN1Sequence(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Sequence(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Sequence(Vector vector) {
        this.elements = vector;
        this.bodyLength = 0;
        int n = 0;
        int n2 = this.elements.size();
        while (n < n2) {
            this.bodyLength += ((ASN1Object)this.elements.elementAt(n)).length();
            ++n;
        }
    }

    public void addElement(ASN1Object aSN1Object) {
        this.elements.addElement(aSN1Object);
        this.bodyLength += aSN1Object.length();
        this.header = null;
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.elements.elementAt(n);
    }

    public Vector elements() {
        return this.elements;
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.elements.firstElement();
    }

    public ASN1Header getHeader() {
        if (this.header == null) {
            this.header = ASN1Sequence.makeHeader(this.bodyLength);
        }
        return this.header;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.elements = new Vector();
        this.bodyLength = 0;
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
            this.elements.addElement(aSN1Object);
            this.bodyLength += aSN1Object.length();
        }
        aSN1SequenceInputStream.terminate();
        this.header = null;
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.elements.lastElement();
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(16, 0, 1, n);
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        int n = 0;
        int n2 = this.elements.size();
        while (n < n2) {
            ((ASN1Object)this.elements.elementAt(n)).output(outputStream);
            ++n;
        }
    }

    public int size() {
        return this.elements.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SEQUENCE {");
        int n = 0;
        int n2 = this.elements.size();
        while (n < n2) {
            stringBuffer.append(this.elements.elementAt(n).toString());
            if (n != this.elements.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

