/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.KeyUtils;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;

public final class Arcfour
extends Cipher {
    private int[] state;
    private int x;
    private int y;

    public Arcfour() {
        this.cipherStateInit();
    }

    public String algName() {
        return "Arcfour";
    }

    private void cipherStateInit() {
        if (this.state == null) {
            this.state = new int[256];
        }
        int n = 0;
        while (n < 256) {
            this.state[n] = n;
            ++n;
        }
        this.x = 0;
        this.y = 0;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        byte[] byArray2 = new byte[n2];
        this.decrypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertDecryption();
        this.decryption(byArray, n, n2, byArray2, n3);
    }

    private void decryption(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        FIPS_140_2.assertReadyState();
        int n4 = n + n2;
        int[] nArray = this.state;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7;
            ++this.x;
            this.x &= 0xFF;
            int n8 = nArray[this.x];
            this.y += n8;
            this.y &= 0xFF;
            nArray[this.x] = n7 = nArray[this.y];
            nArray[this.y] = n8;
            byArray2[n6] = (byte)(nArray[n8 + n7 & 0xFF] ^ byArray[n5]);
            ++n5;
            ++n6;
        }
    }

    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        byte[] byArray2 = new byte[n2];
        this.encrypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertEncryption();
        this.encryption(byArray, n, n2, byArray2, n3);
    }

    private void encryption(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        FIPS_140_2.assertReadyState();
        int n4 = n + n2;
        int[] nArray = this.state;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7;
            ++this.x;
            this.x &= 0xFF;
            int n8 = nArray[this.x];
            this.y += n8;
            this.y &= 0xFF;
            nArray[this.x] = n7 = nArray[this.y];
            nArray[this.y] = n8;
            byArray2[n6] = (byte)(nArray[n8 + n7 & 0xFF] ^ byArray[n5]);
            ++n5;
            ++n6;
        }
    }

    public void erase() {
        this.cipherStateInit();
        super.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        return AlgID.RC4;
    }

    public final int getBlockSize() {
        return 1;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (!algorithmIdentifier.getOID().equals(AlgID.RC4.getOID())) {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier for Arcfour");
        }
        this.rbs = randomBitsSource;
        this.initialize((SymmetricKey)key);
    }

    public void initialize(SymmetricKey symmetricKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        this.key = symmetricKey;
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    private byte performArcfourOperation(byte by) {
        int n;
        int[] nArray = this.state;
        ++this.x;
        this.x &= 0xFF;
        int n2 = nArray[this.x];
        this.y += n2;
        this.y &= 0xFF;
        nArray[this.x] = n = nArray[this.y];
        nArray[this.y] = n2;
        return (byte)(nArray[n2 + n & 0xFF] ^ by);
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) {
        byte[] byArray = symmetricKey.getBytesInternal();
        int[] nArray = this.state;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 256) {
            n2 = (byArray[n] & 0xFF) + nArray[n3] + n2 & 0xFF;
            int n4 = nArray[n3];
            nArray[n3] = nArray[n2];
            nArray[n2] = n4;
            ++n;
            n %= byArray.length;
            ++n3;
        }
    }

    private byte[] unwrapKey(byte[] byArray) throws CipherException {
        this.assertKeyUnwrap();
        byte[] byArray2 = new byte[byArray.length];
        this.decryption(byArray, 0, byArray.length, byArray2, 0);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        return byArray2;
    }

    public PrivateKey unwrapPrivateKey(byte[] byArray) throws CipherException {
        byte[] byArray2 = this.unwrapKey(byArray);
        PrivateKey privateKey = null;
        try {
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        catch (IOException iOException) {
            throw new CipherException(iOException.toString());
        }
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public SymmetricKey unwrapSymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws CipherException {
        byte[] byArray2 = this.unwrapKey(byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2, algorithmIdentifier);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    public byte[] wrapKey(PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot wrap encrypted key");
        }
        return this.wrapKey(KeyUtils.getEncodedInternal(privateKey));
    }

    public byte[] wrapKey(SymmetricKey symmetricKey) throws CipherException {
        return this.wrapKey(symmetricKey.getBytesInternal());
    }

    private byte[] wrapKey(byte[] byArray) throws CipherException {
        this.assertKeyWrap();
        byte[] byArray2 = new byte[byArray.length];
        this.encryption(byArray, 0, byArray.length, byArray2, 0);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        return byArray2;
    }
}

