/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.Coder;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.IntConstant;
import com.phaos.utils.OIDManager;

public abstract class Cipher
extends Coder {
    private Op op;
    protected int mode;
    protected Key key;
    protected RandomBitsSource rbs;
    public static final int ECB = 0;
    public static final int CBC = 1;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected Cipher() {
    }

    protected final void assertDecryption() throws CipherException {
        if (this.op == Op.DECRYPTION) {
            return;
        }
        if (this.op == null) {
            this.op = Op.DECRYPTION;
            return;
        }
        throw new CipherException("A Cipher may not be used in decryption mode after it has been been used in another mode without being re-initialized");
    }

    protected final void assertEncryption() throws CipherException {
        if (this.op == Op.ENCRYPTION) {
            return;
        }
        if (this.op == null) {
            this.op = Op.ENCRYPTION;
            return;
        }
        throw new CipherException("A Cipher may not be used in encryption mode after it has been been used in another mode without being re-initialized");
    }

    protected final void assertKeyUnwrap() throws CipherException {
        if (this.op == Op.KEY_UNWRAP) {
            return;
        }
        if (this.op == null) {
            this.op = Op.KEY_UNWRAP;
            return;
        }
        throw new CipherException("A Cipher may not be used for key-unwrap after it has been been used in another mode without being re-initialized");
    }

    protected final void assertKeyWrap() throws CipherException {
        if (this.op == Op.KEY_WRAP) {
            return;
        }
        if (this.op == null) {
            this.op = Op.KEY_WRAP;
            return;
        }
        throw new CipherException("A Cipher may not be used for key-wrap after it has been been used in another mode without being re-initialized");
    }

    public Key cloneKey() {
        FIPS_140_2.assertReadyState();
        if (this.key != null) {
            return (Key)this.key.clone();
        }
        return null;
    }

    public final byte[] decodeOp(byte[] byArray) throws CipherException {
        return this.decrypt(byArray);
    }

    public byte[] decrypt(byte[] byArray) throws CipherException {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws CipherException {
        FIPS_140_2.assertReadyState();
        return this.decrypt(byArray, n, n2, false);
    }

    public abstract byte[] decrypt(byte[] var1, int var2, int var3, boolean var4) throws CipherException;

    public abstract void decrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CipherException;

    public byte[] decrypt(byte[] byArray, boolean bl) throws CipherException {
        return this.decrypt(byArray, 0, byArray.length, bl);
    }

    public final byte[] encodeOp(byte[] byArray) throws CipherException {
        return this.encrypt(byArray);
    }

    public byte[] encrypt(byte[] byArray) throws CipherException {
        return this.encrypt(byArray, 0, byArray.length);
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) throws CipherException {
        FIPS_140_2.assertReadyState();
        return this.encrypt(byArray, n, n2, false);
    }

    public abstract byte[] encrypt(byte[] var1, int var2, int var3, boolean var4) throws CipherException;

    public abstract void encrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CipherException;

    public byte[] encrypt(byte[] byArray, boolean bl) throws CipherException {
        return this.encrypt(byArray, 0, byArray.length, bl);
    }

    public void erase() {
        this.key = null;
        this.releaseOp();
    }

    public void finalize() {
        this.erase();
    }

    public abstract AlgorithmIdentifier getAlgID();

    public abstract int getBlockSize();

    public byte[] getIV() {
        return null;
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        return Cipher.getInstance(algorithmIdentifier, key, null);
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        cipher.initialize(algorithmIdentifier, key, randomBitsSource);
        return cipher;
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        return Cipher.getInstance(algorithmIdentifier, symmetricKey, iD, null);
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        cipher.initialize(algorithmIdentifier, symmetricKey, iD, randomBitsSource);
        return cipher;
    }

    public static Cipher getInstance(PrivateKey privateKey) throws AlgorithmIdentifierException, InvalidKeyException {
        FIPS_140_2.assertReadyState();
        AlgorithmIdentifier algorithmIdentifier = privateKey.getAlgID();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for the private key with AlgorithmIdentifier: " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        try {
            cipher.initialize(algorithmIdentifier, privateKey);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
        return cipher;
    }

    public static Cipher getInstance(PublicKey publicKey) throws AlgorithmIdentifierException, InvalidKeyException {
        FIPS_140_2.assertReadyState();
        AlgorithmIdentifier algorithmIdentifier = publicKey.getAlgID();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for the public key with AlgorithmIdentifier: " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.instantiate(clazz);
        try {
            cipher.initialize(algorithmIdentifier, publicKey);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
        return cipher;
    }

    public int getMode() {
        FIPS_140_2.assertReadyState();
        return this.mode;
    }

    public Padding.ID getPaddingID() {
        return null;
    }

    RandomBitsSource getRBS() {
        FIPS_140_2.assertReadyState();
        if (this.rbs != null) {
            return this.rbs;
        }
        return RandomBitsSource.getDefault();
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        this.initialize(algorithmIdentifier, key, null);
    }

    public abstract void initialize(AlgorithmIdentifier var1, Key var2, RandomBitsSource var3) throws AlgorithmIdentifierException, InvalidKeyException, CipherException;

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        this.initialize(algorithmIdentifier, symmetricKey, iD, null);
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        throw new AlgorithmIdentifierException("This Cipher instance is not a block Cipher");
    }

    private static Cipher instantiate(Class clazz) throws AlgorithmIdentifierException {
        Cipher cipher;
        try {
            cipher = (Cipher)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Cipher.");
        }
        return cipher;
    }

    protected final void releaseOp() {
        this.op = null;
    }

    public abstract PrivateKey unwrapPrivateKey(byte[] var1) throws CipherException;

    public abstract SymmetricKey unwrapSymmetricKey(byte[] var1, AlgorithmIdentifier var2) throws CipherException;

    public abstract byte[] wrapKey(PrivateKey var1) throws CipherException;

    public abstract byte[] wrapKey(SymmetricKey var1) throws CipherException;

    private static final class Op
    extends IntConstant {
        static final Op ENCRYPTION = new Op(0, "ENCRYPTION");
        static final Op DECRYPTION = new Op(1, "DECRYPTION");
        static final Op KEY_WRAP = new Op(2, "KEY_WRAP");
        static final Op KEY_UNWRAP = new Op(3, "KEY_UNWRAP");

        private Op(int n, String string) {
            super(n, string);
        }
    }
}

