/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.Coder;
import com.phaos.crypto.CoderException;
import com.phaos.fips.FIPS_140_2;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CoderOutputStream
extends FilterOutputStream {
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected int mode = 1;
    protected Coder coder;
    protected byte[] buf;
    protected int count;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public CoderOutputStream(OutputStream outputStream, Coder coder) {
        super(outputStream);
        this.coder = coder;
        this.buf = new byte[this.coder.getBlockSize()];
        this.count = 0;
    }

    public synchronized void flush() throws IOException {
        if (this.count != 0) {
            throw new IOException("Data length not multiple of block size");
        }
        this.out.flush();
    }

    public Coder getCoder() {
        return this.coder;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public synchronized void write(int n) throws IOException {
        FIPS_140_2.assertReadyState();
        this.buf[this.count++] = (byte)n;
        try {
            if (this.count == this.coder.getBlockSize()) {
                this.count = 0;
                if (this.mode == 1) {
                    this.out.write(this.coder.encodeOp(this.buf));
                } else {
                    this.out.write(this.coder.decodeOp(this.buf));
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            this.write(byArray[n3]);
            ++n3;
        }
    }
}

