/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DES;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Padding;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;

public final class DES_EDE
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private int[] k;
    private int[] k2;
    private int[] k3;
    private int[] halves;
    private byte[] buf1;
    private byte[] buf2;
    private boolean keyMaterialInitialized;

    public DES_EDE() {
        super(8);
        this.mode = 0;
        this.halves = new int[2];
    }

    public String algName() {
        return "DES-EDE" + (this.mode == 1 ? "-CBC" : "");
    }

    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (!this.keyMaterialInitialized) {
            this.initKeyMaterial(false);
        }
        DES.processBlock(byArray, n, this.buf1, 0, this.k3, this.halves);
        DES.processBlock(this.buf1, 0, this.buf2, 0, this.k2, this.halves);
        DES.processBlock(this.buf2, 0, byArray2, n2, this.k, this.halves);
    }

    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (!this.keyMaterialInitialized) {
            this.initKeyMaterial(true);
        }
        DES.processBlock(byArray, n, this.buf1, 0, this.k, this.halves);
        DES.processBlock(this.buf1, 0, this.buf2, 0, this.k2, this.halves);
        DES.processBlock(this.buf2, 0, byArray2, n2, this.k3, this.halves);
    }

    public void erase() {
        super.erase();
        Utils.setArray(this.k, 0);
        Utils.setArray(this.k2, 0);
        Utils.setArray(this.k3, 0);
        Utils.setArray(this.buf1, (byte)0);
        Utils.setArray(this.buf2, (byte)0);
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.mode == 0) {
            return AlgID.DES_EDE3_ECB;
        }
        if (this.mode == 1) {
            return new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), this.getIV());
        }
        throw new IllegalStateException("unknown mode " + this.mode);
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.mode = 0;
        } else if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_CBC.getOID())) {
            this.mode = 1;
            this.initCBC(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for DES_EDE");
        }
    }

    private void initCBC(byte[] byArray) throws AlgorithmIdentifierException {
        try {
            if (byArray != null) {
                this.setIV(byArray);
            } else if (this.iv == null) {
                this.setIV(this.getRBS().randomBytes(new byte[this.getBlockSize()]));
            } else {
                this.setIV(this.iv);
            }
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    private void initKeyMaterial(boolean bl) {
        byte[] byArray = ((SymmetricKey)this.key).getBytesInternal();
        if (byArray.length != 24 && byArray.length != 16 && byArray.length != 8) {
            throw new IllegalArgumentException("DES-EDE key must be 8, 16 or 24 bytes long.");
        }
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        if (byArray.length > 8) {
            System.arraycopy(byArray, 8, byArray3, 0, 8);
        } else {
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
        }
        if (byArray.length > 16) {
            System.arraycopy(byArray, 16, byArray4, 0, 8);
        } else {
            System.arraycopy(byArray2, 0, byArray4, 0, 8);
        }
        this.k = new int[32];
        this.k2 = new int[32];
        this.k3 = new int[32];
        DES.initKey(byArray2, this.k, bl);
        DES.initKey(byArray3, this.k2, bl ^ true);
        DES.initKey(byArray4, this.k3, bl);
        if (this.buf1 == null) {
            this.buf1 = new byte[8];
            this.buf2 = new byte[8];
        }
        Utils.setArray(byArray2, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        Utils.setArray(byArray4, (byte)0);
        this.keyMaterialInitialized = true;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.key = symmetricKey;
        this.keyMaterialInitialized = false;
        this.releaseOp();
        this.rbs = randomBitsSource;
        this.iv = null;
        this.init(algorithmIdentifier);
        this.paddingID = iD;
    }

    public String toString() {
        return this.algName();
    }
}

