/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.Key;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public abstract class DHKey
implements Key,
ASN1Object {
    protected DHParams params;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected DHKey() {
    }

    protected DHKey(DHParams dHParams) {
        this.params = dHParams;
    }

    protected DHKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public abstract Object clone();

    public abstract void erase();

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public abstract boolean getAllowExport();

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    public abstract byte[] getEncoded();

    public abstract String getFormat();

    public DHParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.params;
    }

    public abstract void input(InputStream var1) throws IOException;

    public abstract int length();

    public abstract void output(OutputStream var1) throws IOException;

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public abstract void setParams(DHParams var1);

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }
}

