/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyAgreement;
import com.phaos.crypto.KeyAgreementException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.Utils;

public class DHKeyAgreement
extends KeyAgreement {
    private static final ASN1ObjectID dhAlgOID = AlgID.dh.getOID();
    private DHPublicKey pubKey;
    private DHPrivateKey privKey;

    public DHKeyAgreement() {
    }

    public DHKeyAgreement(DHPrivateKey dHPrivateKey) throws InvalidKeyException {
        this.setPrivateKey(dHPrivateKey);
    }

    public DHKeyAgreement(DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey) throws InvalidKeyException {
        this.setPrivateKey(dHPrivateKey);
        this.setPublicKey(dHPublicKey);
    }

    public DHKeyAgreement(DHPublicKey dHPublicKey) throws InvalidKeyException {
        this.setPublicKey(dHPublicKey);
    }

    public String algName() {
        return "Diffie-Hellman";
    }

    public byte[] generateSecret() throws KeyAgreementException {
        FIPS_140_2.assertReadyState();
        if (this.privKey == null) {
            throw new IllegalStateException("Local party private key is not set yet.");
        }
        if (this.pubKey == null) {
            throw new IllegalStateException("Other party public key is not set yet.");
        }
        DHParams dHParams = this.privKey.getParams();
        DHParams dHParams2 = this.pubKey.getParams();
        BigInt bigInt = dHParams.getPInternal();
        BigInt bigInt2 = dHParams.getGInternal();
        BigInt bigInt3 = dHParams.getQInternal();
        if (bigInt.compareTo(dHParams2.getPInternal()) != 0 || bigInt2.compareTo(dHParams2.getGInternal()) != 0 || bigInt3.compareTo(dHParams2.getQInternal()) != 0) {
            throw new KeyAgreementException("Mismatched parameters for local party private key and other party public key");
        }
        BigInt bigInt4 = this.pubKey.getYInternal().modPow(this.privKey.getXInternal(), bigInt);
        if (bigInt4.compareTo(BigInt.ONE) == 0) {
            throw new KeyAgreementException("A trivial secret value was generated");
        }
        return Utils.toByteArray(bigInt4);
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(dhAlgOID, false);
    }

    public PublicKey getPublicKey() {
        FIPS_140_2.assertReadyState();
        return this.pubKey;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (!algorithmIdentifier.getOID().equals(dhAlgOID)) {
            throw new AlgorithmIdentifierException("Not a Diffie-Hellman key agreement algorithm identifier.");
        }
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof DHPrivateKey)) {
            throw new InvalidKeyException("The key is not a DHPrivateKey.");
        }
        DHParams dHParams = ((DHPrivateKey)privateKey).getParams();
        if (dHParams == null || dHParams.getPInternal() == null || dHParams.getQInternal() == null || dHParams.getGInternal() == null) {
            throw new InvalidKeyException("Missing parameters in the private key");
        }
        this.privKey = (DHPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof DHPublicKey)) {
            throw new InvalidKeyException("The key is not a DHPublicKey.");
        }
        DHParams dHParams = ((DHPublicKey)publicKey).getParams();
        if (dHParams == null || dHParams.getPInternal() == null || dHParams.getQInternal() == null || dHParams.getGInternal() == null) {
            throw new InvalidKeyException("Missing parameters in the public key");
        }
        this.pubKey = (DHPublicKey)publicKey;
    }
}

