/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParameterGenerator;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.BigInt;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private static final ASN1ObjectID algOID = AlgID.dh.getOID();
    private DHParams params;
    private boolean initialized = false;
    static /* synthetic */ Class class$com$phaos$ASN1$ASN1Null;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        BigInt bigInt = this.params.getPInternal();
        BigInt bigInt2 = this.params.getQInternal();
        BigInt bigInt3 = this.params.getGInternal();
        BigInt bigInt4 = null;
        int n = bigInt2.bitLength();
        while ((bigInt4 = this.rbs.randomBigInt(n)).compareTo(BigInt.ONE) <= 0 || bigInt4.compareTo(bigInt2) >= 0) {
        }
        BigInt bigInt5 = bigInt3.modPow(bigInt4, bigInt);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInt5, this.params);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInt4, this.params);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
        dHParameterGenerator.initialize(n, n2, randomBitsSource);
        this.initialize(dHParameterGenerator.generateParameters(), randomBitsSource);
    }

    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(n, 160, randomBitsSource);
    }

    public void initialize(DHParams dHParams, RandomBitsSource randomBitsSource) {
        this.params = dHParams;
        this.setRandomBitsSource(randomBitsSource);
        this.initialized = true;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(algOID)) {
            throw new AlgorithmIdentifierException("Unknown DH key algorithm identifier");
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null && aSN1Object.getClass() != (class$com$phaos$ASN1$ASN1Null != null ? class$com$phaos$ASN1$ASN1Null : (class$com$phaos$ASN1$ASN1Null = DHKeyPairGenerator.class$("com.phaos.ASN1.ASN1Null")))) {
            this.params = (DHParams)aSN1Object;
        }
    }
}

