/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.Utils;

public class DHParameterGenerator {
    private int L;
    private int m;
    private RandomBitsSource rbs;
    boolean initialized = false;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    static BigInt generateP(BigInt bigInt, byte[] byArray, int n, int n2, int n3, MessageDigest messageDigest) {
        int n4 = (n3 + 159) / 160;
        int n5 = (n2 + 159) / 160;
        BigInt bigInt2 = new BigInt(byArray).add(BigInt.valueOf(2 * n4)).add(BigInt.valueOf(n5 * n));
        BigInt bigInt3 = BigInt.ZERO;
        int n6 = 0;
        while (n6 < n5) {
            messageDigest.init();
            messageDigest.update(bigInt2.add(BigInt.valueOf(n6)).toByteArray());
            messageDigest.computeCurrent();
            bigInt3 = bigInt3.add(new BigInt(1, messageDigest.getDigestBits()).shiftLeft(160 * n6));
            ++n6;
        }
        if (!(bigInt3 = bigInt3.mod(BigInt.ONE.shiftLeft(n2))).testBit(n2 - 1)) {
            bigInt3 = bigInt3.flipBit(n2 - 1);
        }
        bigInt3 = bigInt3.subtract(bigInt3.mod(bigInt.shiftLeft(1))).add(BigInt.ONE);
        return bigInt3;
    }

    public DHParams generateParameters() {
        BigInt bigInt;
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        BigInt bigInt2 = null;
        byte[] byArray = new byte[this.m / 8 + 1];
        while (!(bigInt2 = DHParameterGenerator.generateQ(byArray = this.rbs.randomBytes(byArray), this.m, messageDigest)).isProbablePrime(100)) {
        }
        BigInt bigInt3 = null;
        int n = 0;
        int n2 = (this.L + 1023) / 1024;
        while (!((bigInt3 = DHParameterGenerator.generateP(bigInt2, byArray, n, this.L, this.m, messageDigest)).compareTo(BigInt.ONE.shiftLeft(this.L - 1)) > 0 && bigInt3.isProbablePrime(100) || ++n >= 4096 * n2)) {
        }
        if (n >= 4096 * n2) {
            throw new RuntimeException("Failed in generating primes");
        }
        BigInt bigInt4 = bigInt3.subtract(BigInt.ONE).divide(bigInt2);
        BigInt bigInt5 = BigInt.TWO;
        while (true) {
            if ((bigInt = bigInt5.modPow(bigInt4, bigInt3)).compareTo(BigInt.ONE) > 0) break;
            bigInt5 = bigInt5.add(BigInt.ONE);
        }
        bigInt5 = bigInt;
        return new DHParams(bigInt3, bigInt5, bigInt2, bigInt4, byArray, n);
    }

    static BigInt generateQ(byte[] byArray, int n, MessageDigest messageDigest) {
        int n2 = (n + 159) / 160;
        BigInt bigInt = new BigInt(byArray);
        BigInt bigInt2 = BigInt.ZERO;
        int n3 = 0;
        while (n3 < n2) {
            messageDigest.init();
            messageDigest.update(bigInt.add(BigInt.valueOf(n3)).toByteArray());
            messageDigest.computeCurrent();
            byte[] byArray2 = messageDigest.getDigestBits();
            messageDigest.init();
            messageDigest.update(bigInt.add(BigInt.valueOf(n3 + n2)).toByteArray());
            messageDigest.computeCurrent();
            byArray2 = Utils.xor(byArray2, messageDigest.getDigestBits());
            bigInt2 = bigInt2.add(new BigInt(1, byArray2).shiftLeft(160 * n3));
            ++n3;
        }
        if (!(bigInt2 = bigInt2.mod(BigInt.ONE.shiftLeft(n))).testBit(0)) {
            bigInt2 = bigInt2.flipBit(0);
        }
        if (!bigInt2.testBit(n - 1)) {
            bigInt2 = bigInt2.flipBit(n - 1);
        }
        return bigInt2;
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public void initialize(int n, int n2) {
        this.initialize(n, n2, RandomBitsSource.getDefault());
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        if (n % 256 != 0 || n < 1024) {
            throw new IllegalArgumentException("L=" + n + " is not a mutiple of 256 of a factor not less than 4");
        }
        this.L = n;
        if (n2 < 160) {
            throw new IllegalArgumentException("m=" + n2 + " is smaller than 160");
        }
        this.m = n2;
        this.rbs = randomBitsSource;
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        this.initialized = true;
    }
}

